/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs7.envelope;

import cn.com.syan.jcee.common.impl.CipherException;
import cn.com.syan.jcee.common.impl.SparkCipher;
import cn.com.syan.jcee.common.impl.pkcs7.envelope.OperatorHelper;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.operator.AsymmetricKeyWrapper;
import org.spongycastle.operator.GenericKey;
import org.spongycastle.operator.OperatorException;

public class SparkAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private OperatorHelper helper;
    private Map extraMappings;
    private PublicKey publicKey;
    private SecureRandom random;

    public SparkAsymmetricKeyWrapper(PublicKey publicKey) {
        super(publicKey.getAlgorithm().equals("RSA") ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"), null) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.3"), null));
        this.helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
        this.extraMappings = new HashMap();
        this.publicKey = publicKey;
    }

    public SparkAsymmetricKeyWrapper(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    protected SparkAsymmetricKeyWrapper(AlgorithmIdentifier algorithmId) {
        super(algorithmId);
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        return this.publicKey.getAlgorithm().equals("RSA") ? this.rsaGenerateWrappedKey(encryptionKey) : this.sm2GenerateWrappedKey(encryptionKey);
    }

    private byte[] sm2GenerateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        byte[] encryptedKeyBytes = null;
        try {
            SparkCipher sparkCipher = SparkCipher.getInstance("SM2");
            sparkCipher.init(1, this.publicKey);
            sparkCipher.update(this.getJceKey(encryptionKey).getEncoded());
            encryptedKeyBytes = sparkCipher.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (CipherException e) {
            e.printStackTrace();
        }
        return encryptedKeyBytes;
    }

    private byte[] rsaGenerateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Cipher keyEncryptionCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.getAlgorithmIdentifier());
        byte[] encryptedKeyBytes = null;
        try {
            if (algParams != null) {
                keyEncryptionCipher.init(3, (Key)this.publicKey, algParams, this.random);
            } else {
                keyEncryptionCipher.init(3, (Key)this.publicKey, this.random);
            }
            encryptedKeyBytes = keyEncryptionCipher.wrap(this.getJceKey(encryptionKey));
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        if (encryptedKeyBytes == null) {
            try {
                keyEncryptionCipher.init(1, (Key)this.publicKey, this.random);
                encryptedKeyBytes = keyEncryptionCipher.doFinal(this.getJceKey(encryptionKey).getEncoded());
            }
            catch (InvalidKeyException var6) {
                throw new OperatorException("unable to encrypt contents key", (Throwable)var6);
            }
            catch (GeneralSecurityException var7) {
                throw new OperatorException("unable to encrypt contents key", (Throwable)var7);
            }
        }
        return encryptedKeyBytes;
    }

    private Key getJceKey(GenericKey key) {
        if (key.getRepresentation() instanceof Key) {
            return (Key)key.getRepresentation();
        }
        if (key.getRepresentation() instanceof byte[]) {
            return new SecretKeySpec((byte[])key.getRepresentation(), "ENC");
        }
        throw new IllegalArgumentException("unknown generic key type");
    }
}

