/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.operator;

import cn.com.syan.jcee.common.impl.SparkSignature;
import cn.com.syan.jcee.common.impl.operator.OperatorCreationException;
import cn.com.syan.jcee.common.impl.operator.OperatorStreamException;
import cn.com.syan.jcee.common.impl.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.operator.ContentSigner;

public class ContentSignerBuilder {
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;

    public ContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        try {
            final SparkSignature sig = SparkSignature.getInstance(this.sigAlgId.getAlgorithm().getId());
            final AlgorithmIdentifier signatureAlgId = this.sigAlgId;
            sig.initSign(privateKey);
            return new ContentSigner(){
                private SignatureOutputStream stream;
                {
                    this.stream = new SignatureOutputStream(sig);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return signatureAlgId;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return this.stream.getSignature();
                    }
                    catch (SignatureException e) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                    }
                }
            };
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperatorCreationException("cannot create signer: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new OperatorCreationException("cannot create signer: " + e.getMessage(), e);
        }
    }

    private class SignatureOutputStream
    extends OutputStream {
        private SparkSignature sig;

        SignatureOutputStream(SparkSignature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) throws IOException {
        }

        byte[] getSignature() throws SignatureException {
            return this.sig.sign();
        }
    }
}

