/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ocsp;

import cn.com.syan.jcee.common.impl.utils.CertificateBuilder;
import cn.com.syan.jcee.common.impl.utils.CertificateExtensionUtil;
import cn.com.syan.jcee.utils.MessageDigestUtil;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.ocsp.CertID;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cert.ocsp.CertificateID;
import org.spongycastle.cert.ocsp.OCSPException;
import org.spongycastle.cert.ocsp.OCSPReq;
import org.spongycastle.cert.ocsp.OCSPReqBuilder;

public class OCSPRequestCreator {
    public static OCSPReq buildOCSPRequest(String cert) throws OCSPException, CertificateException {
        return OCSPRequestCreator.buildOCSPRequest(CertificateBuilder.buildCertificate(cert));
    }

    public static OCSPReq buildOCSPRequest(X509Certificate cert) throws OCSPException {
        OCSPReq ocspReq = null;
        try {
            AlgorithmIdentifier hashAlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"));
            String hashAlgorithm = "SHA1";
            X500Name issuer = new X500Name(cert.getIssuerX500Principal().getName());
            byte[] issuerNameHash = MessageDigestUtil.digestToBinary((byte[])issuer.getEncoded(), (String)hashAlgorithm);
            byte[] issuerKeyHash = CertificateExtensionUtil.getAuthorityKeyIdentifier(cert);
            CertID certID = new CertID(hashAlgorithmIdentifier, (ASN1OctetString)new DEROctetString(issuerNameHash), (ASN1OctetString)new DEROctetString(issuerKeyHash), new ASN1Integer(new BigInteger(cert.getSerialNumber().toByteArray())));
            CertificateID certificateID = new CertificateID(certID);
            X500Name requesterName = new X500Name(cert.getSubjectX500Principal().getName());
            OCSPReqBuilder builder = new OCSPReqBuilder();
            builder.addRequest(certificateID);
            builder.setRequestorName(requesterName);
            ocspReq = builder.build();
        }
        catch (Exception e) {
            throw new OCSPException("failed to build ocsp request", (Throwable)e);
        }
        return ocspReq;
    }
}

