/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.util.encoders.Base64;

public class RSAPrivateKeyGenerator {
    private static final String pkcs1_oid = "1.2.840.113549.1.1.1";

    public static PrivateKey buildPrivateKey(String base64KeyValue) throws InvalidKeyException {
        return RSAPrivateKeyGenerator.buildPrivateKey(Base64.decode((String)base64KeyValue));
    }

    public static PrivateKey buildPrivateKey(byte[] binaryKeyValue, String provider) throws InvalidKeyException {
        PrivateKey prvKey = null;
        try {
            ASN1Sequence privateKeySequence = ASN1Sequence.getInstance((Object)binaryKeyValue);
            ASN1Encodable flag = privateKeySequence.getObjectAt(1);
            if (flag instanceof ASN1Integer) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(pkcs1_oid), (ASN1Encodable)DERNull.INSTANCE);
                DEROctetString keyOctet = new DEROctetString(binaryKeyValue);
                v.add((ASN1Encodable)new ASN1Integer(0L));
                v.add((ASN1Encodable)algorithmIdentifier);
                v.add((ASN1Encodable)keyOctet);
                DERSequence pkcs8KeySpec = new DERSequence(v);
                binaryKeyValue = pkcs8KeySpec.getEncoded();
            }
            PKCS8EncodedKeySpec kspe = new PKCS8EncodedKeySpec(binaryKeyValue);
            KeyFactory keyFac = null;
            keyFac = provider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", provider);
            prvKey = keyFac.generatePrivate(kspe);
        }
        catch (Exception e) {
            throw new InvalidKeyException("failed to generate private key,cause: " + e.getMessage(), e);
        }
        return prvKey;
    }

    public static PrivateKey buildPrivateKey(byte[] binaryKeyValue) throws InvalidKeyException {
        return RSAPrivateKeyGenerator.buildPrivateKey(binaryKeyValue, null);
    }
}

