/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEKeyEncryptor {
    private static final String PBE_ALGORITHM = "PBEWithSHA1AndDESede";
    private static final String ALGORITHM = "PBEWithSHA1AndDESede";
    private String provider = null;

    public PBEKeyEncryptor() {
    }

    public PBEKeyEncryptor(String provider) {
        this.provider = provider;
    }

    public byte[] encryptKey(Key privateKey, char[] password) throws IOException {
        int iteration = 1000;
        byte[] encryptedPrivateKey = null;
        try {
            SecretKey key = this.deriveSecretKey(password);
            Cipher cipher = this.provider == null ? Cipher.getInstance("PBEWithSHA1AndDESede") : Cipher.getInstance("PBEWithSHA1AndDESede", this.provider);
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(PBEKeyEncryptor.getSalt(), iteration);
            cipher.init(1, (Key)key, pbeParameterSpec);
            encryptedPrivateKey = cipher.doFinal(privateKey.getEncoded());
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBEWithSHA1AndDESede");
            algorithmParameters.init(pbeParameterSpec);
            EncryptedPrivateKeyInfo cpki = new EncryptedPrivateKeyInfo(algorithmParameters, encryptedPrivateKey);
            encryptedPrivateKey = cpki.getEncoded();
        }
        catch (Exception e) {
            IOException ioe = new IOException("encrypt key failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return encryptedPrivateKey;
    }

    public byte[] decryptKey(byte[] encryptedKey, char[] password) throws IOException {
        byte[] decryptedKey = null;
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encryptedKey);
            PBEParameterSpec pbeParameterSpec = encryptedPrivateKeyInfo.getAlgParameters().getParameterSpec(PBEParameterSpec.class);
            byte[] encData = encryptedPrivateKeyInfo.getEncryptedData();
            SecretKey key = this.deriveSecretKey(password);
            Cipher cipher = this.provider == null ? Cipher.getInstance("PBEWithSHA1AndDESede") : Cipher.getInstance("PBEWithSHA1AndDESede", this.provider);
            cipher.init(2, (Key)key, pbeParameterSpec);
            decryptedKey = cipher.doFinal(encData);
        }
        catch (Exception e) {
            IOException ioe = new IOException("encrypt key failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return decryptedKey;
    }

    private static byte[] getSalt() {
        byte[] salt = new byte[20];
        try {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            rand.nextBytes(salt);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return salt;
    }

    private SecretKey deriveSecretKey(char[] password) throws IOException {
        SecretKey skey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory skFac = this.provider == null ? SecretKeyFactory.getInstance("PBEWithSHA1AndDESede") : SecretKeyFactory.getInstance("PBEWithSHA1AndDESede", this.provider);
            skey = skFac.generateSecret(keySpec);
        }
        catch (Exception e) {
            IOException ioe = new IOException("getSecretKey failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return skey;
    }
}

