/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.security.ECKeyPairGenerator;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class KeyPairGenerator {
    public static KeyPair generateRSAKeyPair(int keySize) {
        java.security.KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = java.security.KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(keySize, new SecureRandom());
            return keyPairGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static KeyPair generateBCECKeyPair() {
        AsymmetricCipherKeyPair keyPair = ECKeyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        BCECPublicKey ecPublicKey = new BCECPublicKey("SM2", publicKeyParameters, BouncyCastleProvider.CONFIGURATION);
        BCECPrivateKey ecPrivateKey = new BCECPrivateKey("SM2", privateKeyParameters, ecPublicKey, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        return new KeyPair((PublicKey)ecPublicKey, (PrivateKey)ecPrivateKey);
    }
}

