/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import cn.com.syan.jcee.exception.JCEEException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.crypto.EncryptedPrivateKeyInfo;

public class KeyEncryptor {
    public static byte[] encryptKey(Key key, byte[] password) throws JCEEException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA1");
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            byte[] k = key.getEncoded();
            byte[] encrypted = new byte[k.length + 40];
            byte[] keyStream = SecureRandom.getSeed(20);
            System.arraycopy(keyStream, 0, encrypted, 0, 20);
            int count = 0;
            while (count < k.length) {
                sha.reset();
                sha.update(password);
                sha.update(keyStream);
                sha.digest(keyStream, 0, keyStream.length);
                for (int i = 0; i < keyStream.length && count < k.length; ++count, ++i) {
                    encrypted[count + 20] = (byte)(keyStream[i] ^ k[count]);
                }
            }
            sha.reset();
            sha.update(password);
            sha.update(k);
            sha.digest(encrypted, encrypted.length - 20, 20);
            return new EncryptedPrivateKeyInfo("1.3.6.1.4.1.42.2.17.1.1", encrypted).getEncoded();
        }
        catch (Exception x) {
            throw new JCEEException(x.getMessage());
        }
    }

    public static byte[] decryptKey(byte[] encryptedKey, byte[] password) throws UnrecoverableKeyException {
        try {
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encryptedKey);
            byte[] encr = epki.getEncryptedData();
            byte[] keystream = new byte[20];
            System.arraycopy(encr, 0, keystream, 0, 20);
            byte[] check = new byte[20];
            System.arraycopy(encr, encr.length - 20, check, 0, 20);
            byte[] key = new byte[encr.length - 40];
            MessageDigest sha = MessageDigest.getInstance("SHA1");
            int count = 0;
            while (count < key.length) {
                sha.reset();
                sha.update(password);
                sha.update(keystream);
                sha.digest(keystream, 0, keystream.length);
                for (int i = 0; i < keystream.length && count < key.length; ++count, ++i) {
                    key[count] = (byte)(keystream[i] ^ encr[count + 20]);
                }
            }
            sha.reset();
            sha.update(password);
            sha.update(key);
            if (!MessageDigest.isEqual(check, sha.digest())) {
                throw new UnrecoverableKeyException("checksum mismatch");
            }
            return key;
        }
        catch (Exception x) {
            throw new UnrecoverableKeyException(x.getMessage());
        }
    }
}

