/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import cn.com.syan.jcee.common.impl.CipherException;
import cn.com.syan.jcee.common.impl.SparkCipher;
import cn.com.syan.jcee.common.impl.asn1.SM2BCPrivateKey;
import cn.com.syan.jcee.common.impl.ecc.cipher.SM4SymmetricCipher;
import cn.com.syan.jcee.common.impl.key.PublicKeyBuilder;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.key.struct.EnvelopedRSAKeyBlob;
import cn.com.syan.jcee.common.impl.key.struct.EnvelopedSM2KeyBlob;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import cn.com.syan.jcee.common.impl.utils.PrivateKeyBuilder;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.util.encoders.Base64;

public class EncryptionPrivateKeyDecryptor {
    private final String SM2_ALGORITHM = "SM2";

    public byte[] decrypt(PrivateKey signaturePrivateKey, String encryptionCertificate, String encryptionPrivateKeyBlob) throws CertificateException, CipherException {
        byte[] privateKey;
        block9: {
            byte[] encryptedData;
            byte[] symmKey;
            privateKey = null;
            X509Certificate encCert = CertificateConverter.fromBase64(encryptionCertificate);
            byte[] envelopedKeyBlob = Base64.decode((String)encryptionPrivateKeyBlob);
            String algo = encCert.getPublicKey().getAlgorithm();
            int symmAlgoID = -1;
            SM2BCPublicKey ecPublicKey = null;
            try {
                if ("SM2".equals(algo)) {
                    EnvelopedSM2KeyBlob sm2KeyBlob = EnvelopedSM2KeyBlob.getInstance(envelopedKeyBlob);
                    symmKey = this.decrypt(sm2KeyBlob.getWrappedKey().getEncoded(), algo, signaturePrivateKey);
                    encryptedData = sm2KeyBlob.getEncryptedPrivateKey();
                    symmAlgoID = sm2KeyBlob.getSymmAlgID();
                    ecPublicKey = sm2KeyBlob.getECPublicKey();
                } else {
                    EnvelopedRSAKeyBlob rsaKeyBlob = EnvelopedRSAKeyBlob.getInstance(envelopedKeyBlob);
                    symmKey = this.decrypt(rsaKeyBlob.getWrappedKey(), algo, signaturePrivateKey);
                    encryptedData = rsaKeyBlob.getEncryptedData();
                    symmAlgoID = rsaKeyBlob.getSymmAlgID();
                }
            }
            catch (Exception e) {
                throw new CipherException("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u6570\u5b57\u4fe1\u5c01\u5931\u8d25\uff01" + e.getMessage(), e);
            }
            try {
                if (symmAlgoID == 1025) {
                    SM4SymmetricCipher sm4SymmetricCipher = SM4SymmetricCipher.getInstance("ECB");
                    sm4SymmetricCipher.init(0, symmKey);
                    sm4SymmetricCipher.update(encryptedData);
                    if ("SM2".equals(algo)) {
                        byte[] netOnePrivateKey = sm4SymmetricCipher.doFinal();
                        BCECPrivateKey ecPrivateKey = PrivateKeyBuilder.buildBCECPrivateKey(netOnePrivateKey);
                        SM2BCPrivateKey sm2BCPrivateKey = new SM2BCPrivateKey(ecPrivateKey, PublicKeyBuilder.buildBCECPublicKey(ecPublicKey));
                        privateKey = sm2BCPrivateKey.getEncoded();
                    } else {
                        privateKey = sm4SymmetricCipher.doFinal();
                    }
                    break block9;
                }
                throw new Exception("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25\uff01\u5bf9\u79f0\u5bc6\u94a5\u6807\u8bc6ID\u9519\u8bef:" + symmAlgoID);
            }
            catch (Exception e) {
                throw new CipherException("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25\uff01" + e.getMessage(), e);
            }
        }
        return privateKey;
    }

    private byte[] decrypt(byte[] data, String algo, PrivateKey signaturePrivateKey) throws CipherException {
        byte[] decryptedData = null;
        try {
            SparkCipher sparkCipher = algo.equalsIgnoreCase("SM2") ? SparkCipher.getInstance("SM2") : SparkCipher.getInstance("RSA/None/PKCS1Padding");
            sparkCipher.init(2, signaturePrivateKey);
            sparkCipher.update(data);
            decryptedData = sparkCipher.doFinal();
        }
        catch (Exception e) {
            throw new CipherException("\u89e3\u5bc6\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return decryptedData;
    }
}

