/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc.cipher;

import cn.com.syan.jcee.common.impl.CipherException;
import cn.com.syan.jcee.common.impl.ecc.sm4.SM4;
import cn.com.syan.jcee.common.impl.ecc.sm4.SM4Context;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;

public class SM4SymmetricCipher {
    public static final String ECB_MODE = "ECB";
    public static final String CBC_MODE = "CBC";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 0;
    private String mode;
    private int opmode;
    private byte[] symmetricKey;
    private byte[] iv;
    private byte[] contentData;

    private SM4SymmetricCipher(String mode) throws NoSuchAlgorithmException {
        if (mode.equalsIgnoreCase(ECB_MODE) || mode.equals("1.2.156.10197.1.104.1.3")) {
            this.mode = ECB_MODE;
        } else if (mode.equalsIgnoreCase(CBC_MODE) || mode.equals("1.2.156.10197.1.104.1.4")) {
            this.mode = CBC_MODE;
        } else {
            throw new NoSuchAlgorithmException("sm4 symmetric cipher does not support this algorithm: " + mode);
        }
    }

    public static SM4SymmetricCipher getInstance(String mode) throws NoSuchAlgorithmException {
        return new SM4SymmetricCipher(mode);
    }

    public void init(int opmode, byte[] symmKey) throws InvalidKeyException {
        this.init(opmode, symmKey, null);
    }

    public void init(int opmode, byte[] symmKey, byte[] iv) throws InvalidKeyException {
        if (opmode == 1) {
            this.opmode = 1;
        } else if (opmode == 0) {
            this.opmode = 0;
        } else {
            throw new InvalidParameterException("invalid opmode:  " + opmode);
        }
        if (symmKey == null || symmKey.length != 16) {
            throw new InvalidKeyException("invalid symmetric key");
        }
        this.symmetricKey = symmKey;
        if (this.mode.equals(CBC_MODE)) {
            if (iv == null || iv.length != 16) {
                throw new InvalidKeyException("iv is invalid");
            }
            this.iv = iv;
        }
    }

    public void update(byte[] data) {
        this.contentData = data;
    }

    public byte[] doFinal() throws CipherException {
        byte[] finalData = null;
        if (this.symmetricKey == null) {
            throw new IllegalStateException("symmetric key is not initialized");
        }
        if (this.contentData == null) {
            throw new IllegalStateException("no data found");
        }
        SM4Context context = new SM4Context();
        context.mode = this.opmode;
        try {
            SM4 sm4 = new SM4();
            sm4.setKey(context, this.symmetricKey);
            finalData = this.mode.equals(ECB_MODE) ? sm4.cryptWithECB(context, this.contentData) : sm4.cryptWithCBC(context, this.iv, this.contentData);
        }
        catch (InvalidKeyException e) {
            throw new CipherException(e.getMessage(), e);
        }
        return finalData;
    }
}

