/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.crypto.cipher.symmetric;

import cn.com.syan.jcee.common.impl.CipherException;
import cn.com.syan.jcee.common.impl.utils.SparkIOUtils;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.spongycastle.util.encoders.Base64;

public class PBEUtil {
    static final byte[] salt = new byte[]{1, 2, 3, 5, 8, 13, 21, 34};
    static final int ITERATIONS = 1000;

    public static byte[] DecryptPBEWithMD5AndDES(byte[] data, String pin) throws IOException, CipherException {
        return PBEUtil.encryptOrDecrypt(2, data, pin);
    }

    public static byte[] EncryptPBEWithMD5AndDES(byte[] data, String pin) throws IOException, CipherException {
        return PBEUtil.encryptOrDecrypt(1, data, pin);
    }

    public static String DecryptPBEWithMD5AndDES(String b64Data, String pin) throws IOException, CipherException {
        return Base64.toBase64String((byte[])PBEUtil.encryptOrDecrypt(2, Base64.decode((String)b64Data), pin));
    }

    public static String EncryptPBEWithMD5AndDES(String b64Data, String pin) throws IOException, CipherException {
        return Base64.toBase64String((byte[])PBEUtil.encryptOrDecrypt(1, Base64.decode((String)b64Data), pin));
    }

    public static void DecryptPBEWithMD5AndDES(File srcFile, File dstFile, String pin) throws IOException, CipherException {
        byte[] srcData = SparkIOUtils.readAllBytes(srcFile.getCanonicalPath());
        byte[] plainData = PBEUtil.encryptOrDecrypt(2, srcData, pin);
        SparkIOUtils.writeAllBytes(plainData, dstFile.getCanonicalPath());
    }

    public static void EncryptPBEWithMD5AndDES(File srcFile, File dstFile, String pin) throws IOException, CipherException {
        byte[] srcData = SparkIOUtils.readAllBytes(srcFile.getCanonicalPath());
        byte[] cipherData = PBEUtil.encryptOrDecrypt(1, srcData, pin);
        SparkIOUtils.writeAllBytes(cipherData, dstFile.getCanonicalPath());
    }

    private static byte[] encryptOrDecrypt(int mode, byte[] data, String password) throws CipherException {
        byte[] cipherData = null;
        String operation = mode == 1 ? "encrypt" : "decrypt";
        try {
            if (mode != 1 && mode != 2) {
                throw new Exception("invalid mode:" + mode);
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, 1000);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
            cipher.init(mode, (Key)secretKey, pbeParameterSpec);
            cipherData = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CipherException("fail to " + operation + " data.", e);
        }
        return cipherData;
    }
}

