/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.rsa;

import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;

public class RSAEnvelopedKey
implements ASN1Encodable {
    private DERBitString symEncryptedKey;
    private DERBitString encryptedPrivateKey;
    private AlgorithmIdentifier symAlgoID;

    public static RSAEnvelopedKey getInstance(ASN1Sequence sequence) {
        return new RSAEnvelopedKey(sequence);
    }

    private RSAEnvelopedKey(ASN1Sequence sequence) {
        this.symAlgoID = AlgorithmIdentifier.getInstance((Object)sequence.getObjectAt(0));
        this.symEncryptedKey = DERBitString.getInstance((Object)sequence.getObjectAt(1));
        this.encryptedPrivateKey = DERBitString.getInstance((Object)sequence.getObjectAt(2));
    }

    public AlgorithmIdentifier getSymAlgoID() {
        return this.symAlgoID;
    }

    public DERBitString getSymEncryptedKey() {
        return this.symEncryptedKey;
    }

    public DERBitString getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.symAlgoID);
        v.add((ASN1Encodable)this.symEncryptedKey);
        v.add((ASN1Encodable)this.encryptedPrivateKey);
        return new DERSequence(v);
    }
}

