/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.ec;

import java.math.BigInteger;
import java.util.Arrays;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERSequence;

public class SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public SM2Signature(byte[] r, byte[] s) {
        this.r = new ASN1Integer(new BigInteger(1, r));
        this.s = new ASN1Integer(new BigInteger(1, s));
    }

    private SM2Signature(ASN1Sequence seq) {
        this.r = new ASN1Integer(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue());
        this.s = new ASN1Integer(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getPositiveValue());
    }

    public static SM2Signature getInstance(Object o) {
        if (o instanceof SM2Signature) {
            return (SM2Signature)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new SM2Signature(ASN1Sequence.getInstance((Object)o));
        }
        if (o instanceof byte[]) {
            return new SM2Signature(ASN1Sequence.getInstance((Object)o));
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.r);
        v.add((ASN1Encodable)this.s);
        return new DERSequence(v);
    }

    public String toString() {
        String TAB = "\n\t";
        StringBuilder buff = new StringBuilder("SM2Signature::{\n\t");
        buff.append("r=");
        buff.append(this.r);
        buff.append(TAB);
        buff.append("s=");
        buff.append(this.s);
        buff.append("\n}");
        return buff.toString();
    }

    private byte[] delZeros(byte[] content) {
        int zeroNumber = 0;
        for (int i = 31; i >= 0 && content[i] == 0; --i) {
            ++zeroNumber;
        }
        return Arrays.copyOf(content, 32 - zeroNumber);
    }
}

