/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.ec;

import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;

public class SM2Cipher
extends ASN1Object {
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private DEROctetString hash;
    private DEROctetString cipherText;

    public SM2Cipher(BigInteger x, BigInteger y, byte[] hash, byte[] cipherText) {
        this.xCoordinate = new ASN1Integer(x);
        this.yCoordinate = new ASN1Integer(y);
        this.hash = new DEROctetString(hash);
        this.cipherText = new DEROctetString(cipherText);
    }

    private SM2Cipher(ASN1Sequence sequence) {
        this.xCoordinate = ASN1Integer.getInstance((Object)sequence.getObjectAt(0));
        this.yCoordinate = ASN1Integer.getInstance((Object)sequence.getObjectAt(1));
        this.hash = (DEROctetString)DEROctetString.getInstance((Object)sequence.getObjectAt(2));
        this.cipherText = (DEROctetString)DEROctetString.getInstance((Object)sequence.getObjectAt(3));
    }

    public static SM2Cipher getInstance(Object object) throws IOException {
        SM2Cipher instance = null;
        if (object instanceof SM2Cipher) {
            instance = (SM2Cipher)((Object)object);
        } else if (object instanceof ASN1Sequence) {
            instance = new SM2Cipher(ASN1Sequence.getInstance((Object)object));
        } else if (object instanceof byte[]) {
            instance = new SM2Cipher(ASN1Sequence.getInstance((Object)ASN1Sequence.fromByteArray((byte[])((byte[])object))));
        }
        return instance;
    }

    public ASN1Integer getXCoordinate() {
        return this.xCoordinate;
    }

    public ASN1Integer getYCoordinate() {
        return this.yCoordinate;
    }

    public DEROctetString getHash() {
        return this.hash;
    }

    public DEROctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.xCoordinate);
        v.add((ASN1Encodable)this.yCoordinate);
        v.add((ASN1Encodable)this.hash);
        v.add((ASN1Encodable)this.cipherText);
        return new DERSequence(v);
    }
}

