/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.chaincert;

import java.io.IOException;
import java.util.Date;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.DERGeneralizedTime;
import org.spongycastle.asn1.DERSequence;

public class PrivilegeValidty
extends ASN1Object {
    private ASN1Primitive notBefore;
    private ASN1Primitive notAfter;

    public PrivilegeValidty(Date notBefore, Date notAfter) {
        this.notBefore = new ASN1UTCTime(notBefore);
        this.notAfter = new ASN1UTCTime(notAfter);
    }

    public PrivilegeValidty(String notBefore, String notAfter) {
        this.notBefore = new ASN1UTCTime(notBefore);
        this.notAfter = new ASN1UTCTime(notAfter);
    }

    private PrivilegeValidty(ASN1Sequence sequence) {
        if (sequence.getObjectAt(0) instanceof ASN1UTCTime) {
            this.notBefore = ASN1UTCTime.getInstance((Object)sequence.getObjectAt(0));
        } else if (sequence.getObjectAt(0) instanceof DERGeneralizedTime) {
            this.notBefore = DERGeneralizedTime.getInstance((Object)sequence.getObjectAt(0));
        }
        if (sequence.getObjectAt(1) instanceof ASN1UTCTime) {
            this.notAfter = ASN1UTCTime.getInstance((Object)sequence.getObjectAt(1));
        } else if (sequence.getObjectAt(1) instanceof DERGeneralizedTime) {
            this.notAfter = ASN1UTCTime.getInstance((Object)sequence.getObjectAt(1));
        }
    }

    public static PrivilegeValidty getInstance(Object object) throws IOException {
        PrivilegeValidty instance = null;
        if (object instanceof PrivilegeValidty) {
            instance = (PrivilegeValidty)((Object)object);
        } else if (object instanceof ASN1Sequence) {
            instance = new PrivilegeValidty(ASN1Sequence.getInstance((Object)object));
        } else if (object instanceof byte[]) {
            instance = new PrivilegeValidty(ASN1Sequence.getInstance((Object)ASN1Sequence.fromByteArray((byte[])((byte[])object))));
        }
        return instance;
    }

    public ASN1Primitive getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(ASN1Primitive notBefore) {
        this.notBefore = notBefore;
    }

    public ASN1Primitive getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(ASN1Primitive notAfter) {
        this.notAfter = notAfter;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.notBefore);
        v.add((ASN1Encodable)this.notAfter);
        return new DERSequence(v);
    }
}

