/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.chaincert;

import java.io.IOException;
import org.spongycastle.asn1.ASN1Choice;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DERUTF8String;

public class IdentifyCode
extends ASN1Object
implements ASN1Choice {
    private DERPrintableString printableString;
    private int tagValue;
    private DERUTF8String militaryOfficerCardNumber;

    public IdentifyCode(int type, String cardType) {
        if (type == 1) {
            this.militaryOfficerCardNumber = new DERUTF8String(cardType);
            this.tagValue = 1;
        } else {
            this.tagValue = type;
            this.printableString = new DERPrintableString(cardType);
        }
    }

    public IdentifyCode(int type, DERPrintableString residenterCardNumber) {
        this.printableString = residenterCardNumber;
        this.tagValue = type;
    }

    public IdentifyCode(DERUTF8String militaryOfficerCardNumber) {
        this.militaryOfficerCardNumber = militaryOfficerCardNumber;
        this.tagValue = 1;
    }

    public int getTagValue() {
        return this.tagValue;
    }

    public DERUTF8String getMilitaryOfficerCardNumber() {
        return this.militaryOfficerCardNumber;
    }

    public DERPrintableString getPrintableString() {
        return this.printableString;
    }

    public void setPrintableString(DERPrintableString printableString) {
        this.printableString = printableString;
    }

    public void setTagValue(int tagValue) {
        this.tagValue = tagValue;
    }

    public void setMilitaryOfficerCardNumber(DERUTF8String militaryOfficerCardNumber) {
        this.militaryOfficerCardNumber = militaryOfficerCardNumber;
    }

    public static IdentifyCode getInstance(Object o) {
        if (o != null && !(o instanceof IdentifyCode)) {
            if (o instanceof byte[]) {
                try {
                    o = ASN1Primitive.fromByteArray((byte[])((byte[])o));
                }
                catch (IOException var2) {
                    throw new IllegalArgumentException("Invalid encoding in IdentifyCode");
                }
            }
            if (o instanceof DERUTF8String) {
                return new IdentifyCode((DERUTF8String)o);
            }
            if (o instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)o;
                if (taggedObject.getTagNo() == 1) {
                    return new IdentifyCode(DERUTF8String.getInstance((ASN1TaggedObject)taggedObject, (boolean)true));
                }
                return new IdentifyCode(taggedObject.getTagNo(), DERPrintableString.getInstance((ASN1TaggedObject)taggedObject, (boolean)true));
            }
            throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
        }
        return (IdentifyCode)((Object)o);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.printableString != null ? new DERTaggedObject(true, this.tagValue, (ASN1Encodable)this.printableString) : new DERTaggedObject(true, 1, (ASN1Encodable)this.militaryOfficerCardNumber);
    }
}

