/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl;

import cn.com.syan.jcee.common.impl.ecc.SM2Signature;
import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.DigestInfo;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;

public class SparkSignature {
    private static SparkSignature instance;
    private static String signatureAlgorithm;
    private boolean isSM2Signature;
    private SM2Signature sm2Signature = null;
    private Signature rsaSignature = null;
    private ECPublicKey sm2PublicKey;
    private PrivateKey rsaPrivateKey = null;
    private byte[] data = null;

    private SparkSignature() throws NoSuchAlgorithmException {
        if (signatureAlgorithm.equalsIgnoreCase("ECDSASM2withSM3") || signatureAlgorithm.equalsIgnoreCase("1.2.156.10197.1.501")) {
            this.isSM2Signature = true;
            this.sm2Signature = new SM2Signature();
        } else {
            this.rsaSignature = Signature.getInstance(signatureAlgorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SparkSignature getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (!SparkAlgorithmIdentifier.hasAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException("algorithm " + algorithm + " is not supported");
        }
        Class<SparkSignature> clazz = SparkSignature.class;
        synchronized (SparkSignature.class) {
            signatureAlgorithm = algorithm;
            instance = new SparkSignature();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void update(byte[] data) throws SignatureException {
        if (this.isSM2Signature) {
            this.sm2Signature.update(data);
        } else {
            this.rsaSignature.update(data);
            this.data = data;
        }
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        byte[] dataBinary = new byte[len];
        System.arraycopy(data, off, dataBinary, 0, len);
        if (this.isSM2Signature) {
            this.sm2Signature.update(dataBinary);
        } else {
            this.rsaSignature.update(dataBinary);
            this.data = dataBinary;
        }
    }

    public void initUserID(String userID) {
        if (this.isSM2Signature && userID != null) {
            this.sm2Signature.initUserID(userID);
        }
    }

    public void initUserID(String userID, ECPublicKey publicKey) {
        if (this.isSM2Signature) {
            if (userID != null) {
                this.sm2Signature.initUserID(userID);
            }
            this.sm2PublicKey = publicKey;
        }
    }

    public void initVerify(Certificate certificate) throws InvalidKeyException {
        if (this.isSM2Signature) {
            this.sm2Signature.initVerify(certificate);
        } else {
            this.rsaSignature.initVerify(certificate);
        }
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (this.isSM2Signature) {
            this.sm2Signature.initVerify((ECPublicKey)publicKey);
        } else {
            this.rsaSignature.initVerify(publicKey);
        }
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (this.isSM2Signature) {
                this.sm2Signature.initSign((ECPrivateKey)privateKey);
            } else {
                this.rsaSignature.initSign(privateKey);
                this.rsaPrivateKey = privateKey;
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    public boolean verify(byte[] signature) throws SignatureException, InvalidKeyException {
        if (this.isSM2Signature) {
            return this.sm2Signature.verify(signature);
        }
        return this.rsaSignature.verify(signature);
    }

    public byte[] sign() throws SignatureException {
        if (this.isSM2Signature) {
            if (this.sm2PublicKey == null) {
                throw new InvalidParameterException("ECPublicKey should be initialized first.");
            }
            return this.sm2Signature.sign(this.sm2PublicKey);
        }
        return this.rsaSignature.sign();
    }

    public byte[] sign(ECPublicKey publicKey) throws SignatureException {
        if (this.isSM2Signature) {
            return this.sm2Signature.sign(publicKey);
        }
        throw new InvalidParameterException("sm2 signature engine do not support rsa algorithm");
    }

    public byte[] digestSign() throws SignatureException {
        return this.digestSign(false);
    }

    public byte[] digestSign(boolean inNetOne) throws SignatureException {
        if (this.isSM2Signature) {
            return this.sm2Signature.digestSign();
        }
        try {
            String transformation = inNetOne ? "RSA/None/PKCS1Padding" : "RSA";
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, this.rsaPrivateKey);
            byte[] digest = this.getDigestInfo(this.data).getEncoded();
            cipher.update(digest);
            return cipher.doFinal();
        }
        catch (Exception e) {
            throw new SignatureException("\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public final String getAlgorithm() {
        return signatureAlgorithm;
    }

    private DigestInfo getDigestInfo(byte[] md) throws SignatureException {
        String hashIdentifier = "";
        if ("SHA1withRSA".equalsIgnoreCase(this.getAlgorithm())) {
            hashIdentifier = "1.3.14.3.2.26";
        } else if ("SHA256withRSA".equalsIgnoreCase(this.getAlgorithm())) {
            hashIdentifier = "2.16.840.1.101.3.4.2.1";
        } else if ("SHA384withRSA".equalsIgnoreCase(this.getAlgorithm())) {
            hashIdentifier = "2.16.840.1.101.3.4.2.2";
        } else if ("MD5_WITH_RSA".equalsIgnoreCase(this.getAlgorithm())) {
            hashIdentifier = "1.2.840.113549.2.5";
        } else if ("SHA512withRSA".equalsIgnoreCase(this.getAlgorithm())) {
            hashIdentifier = "2.16.840.1.101.3.4.2.3";
        } else {
            throw new SignatureException("\u76ee\u524d\u4e0d\u652f\u6301" + this.getAlgorithm() + "\u7b97\u6cd5");
        }
        return new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(hashIdentifier)), md);
    }
}

