/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl;

import cn.com.syan.jcee.common.impl.CipherException;
import cn.com.syan.jcee.common.impl.asn1.ec.SM2Cipher;
import cn.com.syan.jcee.common.impl.ecc.cipher.ECCipher;
import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.math.ec.ECPoint;

public class SparkCipher {
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    private Cipher cipher = null;
    private ECCipher ecCipher = null;
    private static String cipherTransformation;
    public static final String RSA_PKCS1PADDING = "RSA/None/PKCS1Padding";
    private static SparkCipher instance;
    private int limit = -11;
    private Key cipherKey;
    private int mode = 0;
    private byte[] paramData;

    private SparkCipher(String transformation) throws NoSuchPaddingException, NoSuchAlgorithmException {
        cipherTransformation = transformation;
        if (this.isSM2()) {
            this.ecCipher = new ECCipher();
        } else {
            try {
                this.cipher = cipherTransformation.equalsIgnoreCase(RSA_PKCS1PADDING) ? Cipher.getInstance(RSA_PKCS1PADDING, "BC") : Cipher.getInstance(cipherTransformation);
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
        }
    }

    public static SparkCipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (instance == null) {
            instance = new SparkCipher(transformation);
        } else if (!cipherTransformation.equalsIgnoreCase(transformation)) {
            instance = new SparkCipher(transformation);
        }
        return instance;
    }

    public final void init(int mode, Key key) throws InvalidKeyException {
        if (this.isSM2()) {
            this.mode = mode;
            this.cipherKey = key;
        } else {
            this.cipher.init(mode, key);
            this.limitLength(key);
        }
    }

    private void limitLength(Key key) {
        int keyLength = 0;
        if (key instanceof RSAPublicKey) {
            keyLength = ((RSAPublicKey)key).getModulus().toString(2).length();
        } else if (key instanceof DSAPublicKey) {
            keyLength = ((DSAPublicKey)key).getY().toString(2).length();
        }
        this.limit = keyLength / 8 - 11;
    }

    public final void update(byte[] paramArrayOfByte) throws IllegalBlockSizeException {
        if (this.isSM2()) {
            this.paramData = paramArrayOfByte;
        } else {
            if (paramArrayOfByte.length > this.limit && this.limit != -11) {
                throw new IllegalBlockSizeException("data length must be shorter than " + this.limit);
            }
            this.cipher.update(paramArrayOfByte);
        }
    }

    public final byte[] doFinal() throws CipherException {
        byte[] cipherText = null;
        try {
            if (this.isSM2()) {
                if (this.mode == 1) {
                    SM2BCPublicKey publicKey = (SM2BCPublicKey)((Object)this.cipherKey);
                    ECPoint c1 = this.ecCipher.initEncipher(publicKey.getQ());
                    this.ecCipher.encrypt(this.paramData);
                    byte[] c2 = this.paramData;
                    byte[] c3 = new byte[32];
                    this.ecCipher.doFinal(c3);
                    SM2Cipher sm2Cipher = new SM2Cipher(c1.getAffineXCoord().toBigInteger(), c1.getAffineYCoord().toBigInteger(), c3, c2);
                    cipherText = sm2Cipher.getEncoded();
                } else {
                    BCECPrivateKey privateKey = (BCECPrivateKey)this.cipherKey;
                    SM2Cipher sm2Cipher = SM2Cipher.getInstance(this.paramData);
                    ECPoint c1 = ECDomainParametersHelper.getECCurve().createPoint(sm2Cipher.getXCoordinate().getValue(), sm2Cipher.getYCoordinate().getValue());
                    byte[] c2 = sm2Cipher.getCipherText().getOctets();
                    byte[] c3 = new byte[32];
                    this.ecCipher.initDecipher(privateKey.getD(), c1);
                    this.ecCipher.decrypt(c2);
                    this.ecCipher.doFinal(c3);
                    cipherText = c2;
                    if (!Arrays.equals(c3, sm2Cipher.getHash().getOctets())) {
                        throw new Exception("\u89e3\u5bc6\u6570\u636e\u5931\u8d25, \u5bc6\u6587\u6570\u636e\u53ef\u80fd\u6709\u8bef");
                    }
                }
            } else {
                cipherText = this.cipher.doFinal();
            }
        }
        catch (Exception e) {
            throw new CipherException("\u89e3\u5bc6\u5931\u8d25," + e.getMessage(), e);
        }
        return cipherText;
    }

    private boolean isSM2() {
        return cipherTransformation.equalsIgnoreCase("SM2");
    }

    static {
        instance = null;
    }
}

