/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;

public class SpringMethodVisibilityCheck
extends AbstractSpringCheck {
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers.findFirstToken(62) != null) {
            this.visitPublicMethod(modifiers, ast);
        }
    }

    private void visitPublicMethod(DetailAST modifiers, DetailAST method) {
        if (this.hasOverrideAnnotation(modifiers)) {
            return;
        }
        DetailAST classDef = this.getClassDef(method.getParent());
        if (classDef == null || this.isPublicOrProtected(classDef)) {
            return;
        }
        DetailAST interfaceDef = this.getInterfaceDef(classDef.getParent());
        if (interfaceDef != null && this.isPublicOrProtected(interfaceDef)) {
            return;
        }
        DetailAST ident = method.findFirstToken(58);
        this.log(ident.getLineNo(), ident.getColumnNo(), "methodvisibility.publicMethod", new Object[]{ident.getText()});
    }

    private boolean hasOverrideAnnotation(DetailAST modifiers) {
        for (DetailAST candidate = modifiers.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            DetailAST dot;
            String name;
            if (candidate.getType() != 159 || !"Override".equals(name = ((dot = candidate.findFirstToken(59)) != null ? dot : candidate).findFirstToken(58).getText())) continue;
            return true;
        }
        return false;
    }

    private DetailAST getClassDef(DetailAST ast) {
        return this.findParent(ast, 14);
    }

    private DetailAST getInterfaceDef(DetailAST ast) {
        return this.findParent(ast, 15);
    }

    private DetailAST findParent(DetailAST ast, int classDef) {
        while (ast != null) {
            if (ast.getType() == classDef) {
                return ast;
            }
            ast = ast.getParent();
        }
        return null;
    }

    private boolean isPublicOrProtected(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers == null) {
            return false;
        }
        return modifiers.findFirstToken(62) != null || modifiers.findFirstToken(63) != null;
    }
}

