/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringJUnit5Check
extends AbstractSpringCheck {
    private static final String JUNIT4_TEST_ANNOTATION_NAME = "org.junit.Test";
    private static final List<Annotation> TEST_ANNOTATIONS;
    private static final List<Annotation> LIFECYCLE_ANNOTATIONS;
    private static final Annotation NESTED_ANNOTATION;
    private static final Set<String> BANNED_IMPORTS;
    private List<String> unlessImports = new ArrayList<String>();
    private final List<DetailAST> testMethods = new ArrayList<DetailAST>();
    private final Map<String, FullIdent> imports = new LinkedHashMap<String, FullIdent>();
    private final List<DetailAST> lifecycleMethods = new ArrayList<DetailAST>();
    private final List<DetailAST> nestedTestClasses = new ArrayList<DetailAST>();
    private DetailAST testClass;

    public int[] getAcceptableTokens() {
        return new int[]{9, 30, 14};
    }

    public void beginTree(DetailAST rootAST) {
        this.testClass = null;
        this.imports.clear();
        this.testMethods.clear();
        this.lifecycleMethods.clear();
        this.nestedTestClasses.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 30: {
                this.visitImport(ast);
                break;
            }
            case 14: {
                this.visitClassDefinition(ast);
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        if (this.containsAnnotation(ast, TEST_ANNOTATIONS)) {
            this.testMethods.add(ast);
        }
        if (this.containsAnnotation(ast, LIFECYCLE_ANNOTATIONS)) {
            this.lifecycleMethods.add(ast);
        }
    }

    private boolean containsAnnotation(DetailAST ast, List<Annotation> annotations) {
        List annotationNames = annotations.stream().flatMap(annotation -> Stream.of(((Annotation)annotation).simpleName, ((Annotation)annotation).fullyQualifiedName())).collect(Collectors.toList());
        try {
            return AnnotationUtil.containsAnnotation((DetailAST)ast, annotationNames);
        }
        catch (NoSuchMethodError ex) {
            HashSet annotationNamesSet = new HashSet(annotationNames);
            try {
                return (Boolean)AnnotationUtil.class.getMethod("containsAnnotation", DetailAST.class, Set.class).invoke(null, ast, annotationNamesSet);
            }
            catch (Exception ex2) {
                throw new RuntimeException("containsAnnotation failed", ex2);
            }
        }
    }

    private void visitImport(DetailAST ast) {
        FullIdent ident = FullIdent.createFullIdentBelow((DetailAST)ast);
        this.imports.put(ident.getText(), ident);
    }

    private void visitClassDefinition(DetailAST ast) {
        if (ast.getParent().getType() == 1) {
            this.testClass = ast;
        } else if (this.containsAnnotation(ast, Arrays.asList(NESTED_ANNOTATION))) {
            this.nestedTestClasses.add(ast);
        }
    }

    public void finishTree(DetailAST rootAST) {
        if (this.shouldCheck()) {
            this.check();
        }
    }

    private boolean shouldCheck() {
        if (this.testMethods.isEmpty() && this.lifecycleMethods.isEmpty() && this.nestedTestClasses.isEmpty()) {
            return false;
        }
        for (String unlessImport : this.unlessImports) {
            if (!this.imports.containsKey(unlessImport)) continue;
            return false;
        }
        return true;
    }

    private void check() {
        if (this.testClass != null && !this.isAbstract(this.testClass)) {
            this.checkVisibility(Arrays.asList(this.testClass), "junit5.publicClass", null);
        }
        this.checkVisibility(this.nestedTestClasses, "junit5.publicNestedClass", "junit5.privateNestedClass");
        for (String bannedImport : BANNED_IMPORTS) {
            FullIdent ident = this.imports.get(bannedImport);
            if (ident == null) continue;
            this.log(ident.getLineNo(), ident.getColumnNo(), "junit5.bannedImport", new Object[]{bannedImport});
        }
        for (DetailAST testMethod : this.testMethods) {
            if (!AnnotationUtil.containsAnnotation((DetailAST)testMethod, (String)JUNIT4_TEST_ANNOTATION_NAME)) continue;
            this.log(testMethod, "junit5.bannedTestAnnotation");
        }
        this.checkVisibility(this.testMethods, "junit5.testPublicMethod", "junit5.testPrivateMethod");
        this.checkVisibility(this.lifecycleMethods, "junit5.lifecyclePublicMethod", "junit5.lifecyclePrivateMethod");
    }

    private boolean isAbstract(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        return modifiers.findFirstToken(40) != null;
    }

    private void checkVisibility(List<DetailAST> asts, String publicMessageKey, String privateMessageKey) {
        for (DetailAST ast : asts) {
            DetailAST modifiers = ast.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null) {
                this.log(ast, publicMessageKey);
            }
            if (privateMessageKey == null || modifiers.findFirstToken(61) == null) continue;
            this.log(ast, privateMessageKey);
        }
    }

    private void log(DetailAST ast, String key) {
        String name = ast.findFirstToken(58).getText();
        this.log(ast.getLineNo(), ast.getColumnNo(), key, new Object[]{name});
    }

    public void setUnlessImports(String unlessImports) {
        this.unlessImports = Collections.unmodifiableList(Arrays.stream(unlessImports.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    static {
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>();
        annotations.add(new Annotation("org.junit.jupiter.api", "RepeatedTest"));
        annotations.add(new Annotation("org.junit.jupiter.api", "Test"));
        annotations.add(new Annotation("org.junit.jupiter.api", "TestFactory"));
        annotations.add(new Annotation("org.junit.jupiter.api", "TestTemplate"));
        annotations.add(new Annotation("org.junit.jupiter.api", "ParameterizedTest"));
        TEST_ANNOTATIONS = Collections.unmodifiableList(new ArrayList(annotations));
        annotations = new LinkedHashSet();
        annotations.add(new Annotation("org.junit.jupiter.api", "BeforeAll"));
        annotations.add(new Annotation("org.junit.jupiter.api", "BeforeEach"));
        annotations.add(new Annotation("org.junit.jupiter.api", "AfterAll"));
        annotations.add(new Annotation("org.junit.jupiter.api", "AfterEach"));
        LIFECYCLE_ANNOTATIONS = Collections.unmodifiableList(new ArrayList(annotations));
        NESTED_ANNOTATION = new Annotation("org.junit.jupiter.api", "Nested");
        LinkedHashSet<String> bannedImports = new LinkedHashSet<String>();
        bannedImports.add(JUNIT4_TEST_ANNOTATION_NAME);
        bannedImports.add("org.junit.After");
        bannedImports.add("org.junit.AfterClass");
        bannedImports.add("org.junit.Before");
        bannedImports.add("org.junit.BeforeClass");
        bannedImports.add("org.junit.Rule");
        bannedImports.add("org.junit.ClassRule");
        BANNED_IMPORTS = Collections.unmodifiableSet(bannedImports);
    }

    private static final class Annotation {
        private final String packageName;
        private final String simpleName;

        private Annotation(String packageName, String simpleName) {
            this.packageName = packageName;
            this.simpleName = simpleName;
        }

        private String fullyQualifiedName() {
            return this.packageName + "." + this.simpleName;
        }
    }
}

