/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.design.HideUtilityClassConstructorCheck;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SpringHideUtilityClassConstructor
extends HideUtilityClassConstructorCheck {
    private static final Set<String> BYPASS_ANNOTATIONS;

    public void visitToken(DetailAST ast) {
        if (!this.isBypassed(ast)) {
            super.visitToken(ast);
        }
    }

    private boolean isBypassed(DetailAST ast) {
        for (String bypassAnnotation : BYPASS_ANNOTATIONS) {
            if (!AnnotationUtil.containsAnnotation((DetailAST)ast, (String)bypassAnnotation)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("org.springframework.context.annotation.Configuration");
        annotations.add("org.springframework.boot.autoconfigure.SpringBootApplication");
        annotations.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        Set shortNames = annotations.stream().map(name -> name.substring(name.lastIndexOf(".") + 1)).collect(Collectors.toSet());
        annotations.addAll(shortNames);
        BYPASS_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }
}

