/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.controller;

import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.web.controller.AbstractMetadataController;
import io.spring.initializr.web.support.Agent;
import io.spring.initializr.web.support.CommandLineHelpGenerator;
import java.io.IOException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommandLineMetadataController
extends AbstractMetadataController {
    private final CommandLineHelpGenerator commandLineHelpGenerator;

    public CommandLineMetadataController(InitializrMetadataProvider metadataProvider, TemplateRenderer templateRenderer) {
        super(metadataProvider);
        this.commandLineHelpGenerator = new CommandLineHelpGenerator(templateRenderer);
    }

    @GetMapping(path={"/"}, produces={"text/plain"})
    public ResponseEntity<String> serviceCapabilitiesText(@RequestHeader(value="User-Agent", required=false) String userAgent) throws IOException {
        Agent agent;
        String appUrl = this.generateAppUrl();
        InitializrMetadata metadata = this.metadataProvider.get();
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN);
        if (userAgent != null && (agent = Agent.fromUserAgent(userAgent)) != null) {
            if (Agent.AgentId.CURL.equals((Object)agent.getId())) {
                String content = this.commandLineHelpGenerator.generateCurlCapabilities(metadata, appUrl);
                return ((ResponseEntity.BodyBuilder)builder.eTag(this.createUniqueId(content))).body((Object)content);
            }
            if (Agent.AgentId.HTTPIE.equals((Object)agent.getId())) {
                String content = this.commandLineHelpGenerator.generateHttpieCapabilities(metadata, appUrl);
                return ((ResponseEntity.BodyBuilder)builder.eTag(this.createUniqueId(content))).body((Object)content);
            }
            if (Agent.AgentId.SPRING_BOOT_CLI.equals((Object)agent.getId())) {
                String content = this.commandLineHelpGenerator.generateSpringBootCliCapabilities(metadata, appUrl);
                return ((ResponseEntity.BodyBuilder)builder.eTag(this.createUniqueId(content))).body((Object)content);
            }
        }
        String content = this.commandLineHelpGenerator.generateGenericCapabilities(metadata, appUrl);
        return ((ResponseEntity.BodyBuilder)builder.eTag(this.createUniqueId(content))).body((Object)content);
    }
}

