/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.Defaultable;
import io.spring.initializr.metadata.DependenciesCapability;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import io.spring.initializr.metadata.Repository;
import io.spring.initializr.metadata.SingleSelectCapability;
import io.spring.initializr.metadata.TextCapability;
import io.spring.initializr.metadata.TypeCapability;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InitializrMetadata {
    private final InitializrConfiguration configuration;
    private final DependenciesCapability dependencies = new DependenciesCapability();
    private final TypeCapability types = new TypeCapability();
    private final SingleSelectCapability bootVersions = new SingleSelectCapability("bootVersion", "Spring Boot Version", "spring boot version");
    private final SingleSelectCapability packagings = new SingleSelectCapability("packaging", "Packaging", "project packaging");
    private final SingleSelectCapability javaVersions = new SingleSelectCapability("javaVersion", "Java Version", "language level");
    private final SingleSelectCapability languages = new SingleSelectCapability("language", "Language", "programming language");
    private final TextCapability name = new TextCapability("name", "Name", "project name (infer application name)");
    private final TextCapability description = new TextCapability("description", "Description", "project description");
    private final TextCapability groupId = new TextCapability("groupId", "Group", "project coordinates");
    private final TextCapability artifactId = new ArtifactIdCapability(this.name);
    private final TextCapability version = new TextCapability("version", "Version", "project version");
    private final TextCapability packageName = new PackageCapability(this.groupId, this.artifactId);

    public InitializrMetadata() {
        this(new InitializrConfiguration());
    }

    protected InitializrMetadata(InitializrConfiguration configuration) {
        this.configuration = configuration;
    }

    public InitializrConfiguration getConfiguration() {
        return this.configuration;
    }

    public DependenciesCapability getDependencies() {
        return this.dependencies;
    }

    public TypeCapability getTypes() {
        return this.types;
    }

    public SingleSelectCapability getBootVersions() {
        return this.bootVersions;
    }

    public SingleSelectCapability getPackagings() {
        return this.packagings;
    }

    public SingleSelectCapability getJavaVersions() {
        return this.javaVersions;
    }

    public SingleSelectCapability getLanguages() {
        return this.languages;
    }

    public TextCapability getName() {
        return this.name;
    }

    public TextCapability getDescription() {
        return this.description;
    }

    public TextCapability getGroupId() {
        return this.groupId;
    }

    public TextCapability getArtifactId() {
        return this.artifactId;
    }

    public TextCapability getVersion() {
        return this.version;
    }

    public TextCapability getPackageName() {
        return this.packageName;
    }

    public void merge(InitializrMetadata other) {
        this.configuration.merge(other.configuration);
        this.dependencies.merge(other.dependencies);
        this.types.merge(other.types);
        this.bootVersions.merge(other.bootVersions);
        this.packagings.merge(other.packagings);
        this.javaVersions.merge(other.javaVersions);
        this.languages.merge(other.languages);
        this.name.merge(other.name);
        this.description.merge(other.description);
        this.groupId.merge(other.groupId);
        this.artifactId.merge(other.artifactId);
        this.version.merge(other.version);
        this.packageName.merge(other.packageName);
    }

    public void validate() {
        this.configuration.validate();
        this.dependencies.validate();
        Map<String, Repository> repositories = this.configuration.getEnv().getRepositories();
        Map<String, BillOfMaterials> boms = this.configuration.getEnv().getBoms();
        for (Dependency dependency : this.dependencies.getAll()) {
            if (dependency.getBom() != null && !boms.containsKey(dependency.getBom())) {
                throw new InvalidInitializrMetadataException("Dependency " + dependency + "defines an invalid BOM id " + dependency.getBom() + ", available boms " + boms);
            }
            if (dependency.getRepository() == null || repositories.containsKey(dependency.getRepository())) continue;
            throw new InvalidInitializrMetadataException("Dependency " + dependency + "defines an invalid repository id " + dependency.getRepository() + ", available repositories " + repositories);
        }
        for (BillOfMaterials bom : boms.values()) {
            for (String r : bom.getRepositories()) {
                if (repositories.containsKey(r)) continue;
                throw new InvalidInitializrMetadataException(bom + "defines an invalid repository id " + r + ", available repositories " + repositories);
            }
            for (String b : bom.getAdditionalBoms()) {
                if (boms.containsKey(b)) continue;
                throw new InvalidInitializrMetadataException(bom + " defines an invalid additional bom id " + b + ", available boms " + boms);
            }
            for (BillOfMaterials.Mapping m : bom.getMappings()) {
                for (String r : m.getRepositories()) {
                    if (repositories.containsKey(r)) continue;
                    throw new InvalidInitializrMetadataException(m + " of " + bom + "defines an invalid repository id " + r + ", available repositories " + repositories);
                }
                for (String b : m.getAdditionalBoms()) {
                    if (boms.containsKey(b)) continue;
                    throw new InvalidInitializrMetadataException(m + " of " + bom + " defines an invalid additional bom id " + b + ", available boms " + boms);
                }
            }
        }
    }

    public void updateSpringBootVersions(List<DefaultMetadataElement> versionsMetadata) {
        this.bootVersions.setContent(versionsMetadata);
        List bootVersions = this.bootVersions.getContent().stream().map(it -> Version.parse((String)it.getId())).collect(Collectors.toList());
        VersionParser parser = new VersionParser(bootVersions);
        this.dependencies.updateCompatibilityRange(parser);
        this.configuration.getEnv().updateCompatibilityRange(parser);
    }

    public String createCliDistributionURl(String extension) {
        String bootVersion = InitializrMetadata.defaultId(this.bootVersions);
        return this.configuration.getEnv().getArtifactRepository() + "org/springframework/boot/spring-boot-cli/" + bootVersion + "/spring-boot-cli-" + bootVersion + "-bin." + extension;
    }

    public BillOfMaterials createSpringBootBom(String bootVersion, String versionProperty) {
        BillOfMaterials bom = BillOfMaterials.create("org.springframework.boot", "spring-boot-dependencies", bootVersion);
        bom.setVersionProperty(VersionProperty.of((String)versionProperty));
        bom.setOrder(100);
        return bom;
    }

    public Map<String, Object> defaults() {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        defaults.put("type", InitializrMetadata.defaultId(this.types));
        defaults.put("bootVersion", InitializrMetadata.defaultId(this.bootVersions));
        defaults.put("packaging", InitializrMetadata.defaultId(this.packagings));
        defaults.put("javaVersion", InitializrMetadata.defaultId(this.javaVersions));
        defaults.put("language", InitializrMetadata.defaultId(this.languages));
        defaults.put("groupId", this.groupId.getContent());
        defaults.put("artifactId", this.artifactId.getContent());
        defaults.put("version", this.version.getContent());
        defaults.put("name", this.name.getContent());
        defaults.put("description", this.description.getContent());
        defaults.put("packageName", this.packageName.getContent());
        return defaults;
    }

    private static String defaultId(Defaultable<? extends DefaultMetadataElement> element) {
        DefaultMetadataElement defaultValue = element.getDefault();
        return defaultValue != null ? defaultValue.getId() : null;
    }

    private static class ArtifactIdCapability
    extends TextCapability {
        private final TextCapability nameCapability;

        ArtifactIdCapability(TextCapability nameCapability) {
            super("artifactId", "Artifact", "project coordinates (infer archive name)");
            this.nameCapability = nameCapability;
        }

        @Override
        public String getContent() {
            String value = super.getContent();
            return value != null ? value : this.nameCapability.getContent();
        }
    }

    private static class PackageCapability
    extends TextCapability {
        private final TextCapability groupId;
        private final TextCapability artifactId;

        PackageCapability(TextCapability groupId, TextCapability artifactId) {
            super("packageName", "Package Name", "root package");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        @Override
        public String getContent() {
            String value = super.getContent();
            if (value != null) {
                return value;
            }
            if (this.groupId.getContent() != null && this.artifactId.getContent() != null) {
                return InitializrConfiguration.cleanPackageName(this.groupId.getContent() + "." + this.artifactId.getContent());
            }
            return null;
        }
    }
}

