/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.ClassName;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class AnnotationContainer {
    private final Map<ClassName, Annotation.Builder> annotations;

    public AnnotationContainer() {
        this(new LinkedHashMap<ClassName, Annotation.Builder>());
    }

    private AnnotationContainer(Map<ClassName, Annotation.Builder> annotations) {
        this.annotations = annotations;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public boolean has(ClassName className) {
        return this.annotations.containsKey(className);
    }

    public Stream<Annotation> values() {
        return this.annotations.values().stream().map(Annotation.Builder::build);
    }

    public void add(ClassName className, Consumer<Annotation.Builder> annotation) {
        Annotation.Builder builder = this.annotations.computeIfAbsent(className, key -> new Annotation.Builder(className));
        if (annotation != null) {
            annotation.accept(builder);
        }
    }

    public void add(ClassName className) {
        this.add(className, null);
    }

    public boolean remove(ClassName className) {
        return this.annotations.remove(className) != null;
    }

    public AnnotationContainer deepCopy() {
        LinkedHashMap<ClassName, Annotation.Builder> copy = new LinkedHashMap<ClassName, Annotation.Builder>();
        this.annotations.forEach((className, builder) -> copy.put((ClassName)className, new Annotation.Builder((Annotation.Builder)builder)));
        return new AnnotationContainer(copy);
    }
}

