/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.gradle.Attribute;
import io.spring.initializr.generator.buildsystem.gradle.Invocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class GradleExtension {
    private final String name;
    private final List<Attribute> attributes;
    private final List<Invocation> invocations;
    private final Map<String, GradleExtension> nested;
    private final Set<String> importedTypes;

    protected GradleExtension(Builder builder) {
        this.name = builder.name;
        this.attributes = List.copyOf(builder.attributes.values());
        this.invocations = List.copyOf(builder.invocations);
        this.nested = Collections.unmodifiableMap(GradleExtension.resolve(builder.nested));
        this.importedTypes = GradleExtension.collectImportedTypes(builder);
    }

    private static Set<String> collectImportedTypes(Builder builder) {
        HashSet<String> result = new HashSet<String>();
        GradleExtension.addImportedTypes(result, builder);
        return Collections.unmodifiableSet(result);
    }

    private static void addImportedTypes(Set<String> importedTypes, Builder builder) {
        importedTypes.addAll(builder.importedTypes);
        for (Builder nested : builder.nested.values()) {
            GradleExtension.addImportedTypes(importedTypes, nested);
        }
    }

    private static Map<String, GradleExtension> resolve(Map<String, Builder> extensions) {
        LinkedHashMap<String, GradleExtension> result = new LinkedHashMap<String, GradleExtension>();
        extensions.forEach((name, builder) -> result.put((String)name, builder.build()));
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    public Map<String, GradleExtension> getNested() {
        return this.nested;
    }

    public Set<String> getImportedTypes() {
        return this.importedTypes;
    }

    public static class Builder {
        private final String name;
        private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        private final List<Invocation> invocations = new ArrayList<Invocation>();
        private final Map<String, Builder> nested = new LinkedHashMap<String, Builder>();
        private final Set<String> importedTypes = new HashSet<String>();

        protected Builder(String name) {
            this.name = name;
        }

        public void importType(String type) {
            this.importedTypes.add(type);
        }

        public void attribute(String target, String value) {
            this.attributes.put(target, Attribute.set(target, value));
        }

        public void attributeWithType(String target, String value, String type) {
            this.importType(type);
            this.attribute(target, value);
        }

        public void append(String target, String value) {
            this.attributes.put(target, Attribute.append(target, value));
        }

        public void appendWithType(String target, String value, String type) {
            this.importType(type);
            this.append(target, value);
        }

        public void invoke(String target, String ... arguments) {
            this.invocations.add(new Invocation(target, Arrays.asList(arguments)));
        }

        public void invoke(String target, Collection<String> arguments) {
            this.invocations.add(new Invocation(target, List.copyOf(arguments)));
        }

        public void invokeWithType(String target, String type, String ... arguments) {
            this.importType(type);
            this.invoke(target, arguments);
        }

        public void invokeWithType(String target, String type, Collection<String> arguments) {
            this.importType(type);
            this.invoke(target, arguments);
        }

        public void nested(String name, Consumer<Builder> customizer) {
            customizer.accept(this.nested.computeIfAbsent(name, ignored -> new Builder(name)));
        }

        public GradleExtension build() {
            return new GradleExtension(this);
        }
    }
}

