/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.version.VersionReference;

public class BillOfMaterials {
    private final String groupId;
    private final String artifactId;
    private final VersionReference version;
    private final int order;

    protected BillOfMaterials(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        this.order = builder.order;
    }

    public static Builder withCoordinates(String groupId, String artifactId) {
        return new Builder(groupId, artifactId);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public VersionReference getVersion() {
        return this.version;
    }

    public int getOrder() {
        return this.order;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private VersionReference version;
        private int order = Integer.MAX_VALUE;

        protected Builder(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(VersionReference version) {
            this.version = version;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public BillOfMaterials build() {
            return new BillOfMaterials(this);
        }
    }
}

