/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code;

import io.spring.initializr.generator.language.CompilationUnit;
import io.spring.initializr.generator.language.SourceCode;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.TypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.TestSourceCodeCustomizer;
import io.spring.initializr.generator.spring.util.LambdaSafe;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;

public class TestSourceCodeProjectContributor<T extends TypeDeclaration, C extends CompilationUnit<T>, S extends SourceCode<T, C>>
implements ProjectContributor {
    private final ProjectDescription description;
    private final Supplier<S> sourceFactory;
    private final SourceCodeWriter<S> sourceWriter;
    private final ObjectProvider<TestApplicationTypeCustomizer<?>> testApplicationTypeCustomizers;
    private final ObjectProvider<TestSourceCodeCustomizer<?, ?, ?>> testSourceCodeCustomizers;

    public TestSourceCodeProjectContributor(ProjectDescription description, Supplier<S> sourceFactory, SourceCodeWriter<S> sourceWriter, ObjectProvider<TestApplicationTypeCustomizer<?>> testApplicationTypeCustomizers, ObjectProvider<TestSourceCodeCustomizer<?, ?, ?>> testSourceCodeCustomizers) {
        this.description = description;
        this.sourceFactory = sourceFactory;
        this.sourceWriter = sourceWriter;
        this.testApplicationTypeCustomizers = testApplicationTypeCustomizers;
        this.testSourceCodeCustomizers = testSourceCodeCustomizers;
    }

    public void contribute(Path projectRoot) throws IOException {
        SourceCode sourceCode = (SourceCode)this.sourceFactory.get();
        String testName = this.description.getApplicationName() + "Tests";
        CompilationUnit compilationUnit = sourceCode.createCompilationUnit(this.description.getPackageName(), testName);
        TypeDeclaration testApplicationType = compilationUnit.createTypeDeclaration(testName);
        this.customizeTestApplicationType(testApplicationType);
        this.customizeTestSourceCode(sourceCode);
        this.sourceWriter.writeTo(this.description.getBuildSystem().getTestSource(projectRoot, this.description.getLanguage()), sourceCode);
    }

    private void customizeTestApplicationType(TypeDeclaration testApplicationType) {
        List customizers = this.testApplicationTypeCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(TestApplicationTypeCustomizer.class, customizers, testApplicationType, new Object[0]).invoke(customizer -> customizer.customize(testApplicationType));
    }

    private void customizeTestSourceCode(S sourceCode) {
        List customizers = this.testSourceCodeCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(TestSourceCodeCustomizer.class, customizers, sourceCode, new Object[0]).invoke(customizer -> customizer.customize(sourceCode));
    }
}

