/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.gradle;

import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.gradle.DependencyManagementPluginVersionResolver;

public final class SpringBootPluginBuildCustomizer
implements BuildCustomizer<GradleBuild> {
    public static final int ORDER = -100;
    private final ProjectDescription description;
    private final DependencyManagementPluginVersionResolver versionResolver;

    public SpringBootPluginBuildCustomizer(ProjectDescription description, DependencyManagementPluginVersionResolver versionResolver) {
        this.description = description;
        this.versionResolver = versionResolver;
    }

    @Override
    public void customize(GradleBuild build) {
        build.plugins().add("org.springframework.boot", plugin -> plugin.setVersion(this.description.getPlatformVersion().toString()));
        build.plugins().add("io.spring.dependency-management", plugin -> plugin.setVersion(this.versionResolver.resolveDependencyManagementPluginVersion(this.description)));
    }

    @Override
    public int getOrder() {
        return -100;
    }
}

