/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public class Metrics {
    public static final String DATA_RECEIVED = ".data.received";
    public static final String DATA_SENT = ".data.sent";
    public static final String ERRORS = ".errors";
    public static final String TLS_HANDSHAKE_TIME = ".tls.handshake.time";
    public static final String CONNECT_TIME = ".connect.time";
    public static final String DATA_RECEIVED_TIME = ".data.received.time";
    public static final String DATA_SENT_TIME = ".data.sent.time";
    public static final String RESPONSE_TIME = ".response.time";
    public static final String ADDRESS_RESOLVER = ".address.resolver";
    public static final String REMOTE_ADDRESS = "remote.address";
    public static final String URI = "uri";
    public static final String STATUS = "status";
    public static final String METHOD = "method";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final int MAX_URI_TAGS = 100;

    @Nullable
    public static String formatSocketAddress(@Nullable SocketAddress socketAddress) {
        if (socketAddress != null) {
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)socketAddress;
                return address.getHostString() + ":" + address.getPort();
            }
            return socketAddress.toString();
        }
        return null;
    }
}

