/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.CollectionSchemaOrBuilder;
import io.milvus.grpc.ConsistencyLevel;
import io.milvus.grpc.DescribeCollectionResponseOrBuilder;
import io.milvus.grpc.KeyDataPair;
import io.milvus.grpc.KeyDataPairOrBuilder;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.KeyValuePairOrBuilder;
import io.milvus.grpc.MilvusProto;
import io.milvus.grpc.Status;
import io.milvus.grpc.StatusOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DescribeCollectionResponse
extends GeneratedMessageV3
implements DescribeCollectionResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private Status status_;
    public static final int SCHEMA_FIELD_NUMBER = 2;
    private CollectionSchema schema_;
    public static final int COLLECTIONID_FIELD_NUMBER = 3;
    private long collectionID_ = 0L;
    public static final int VIRTUAL_CHANNEL_NAMES_FIELD_NUMBER = 4;
    private LazyStringArrayList virtualChannelNames_ = LazyStringArrayList.emptyList();
    public static final int PHYSICAL_CHANNEL_NAMES_FIELD_NUMBER = 5;
    private LazyStringArrayList physicalChannelNames_ = LazyStringArrayList.emptyList();
    public static final int CREATED_TIMESTAMP_FIELD_NUMBER = 6;
    private long createdTimestamp_ = 0L;
    public static final int CREATED_UTC_TIMESTAMP_FIELD_NUMBER = 7;
    private long createdUtcTimestamp_ = 0L;
    public static final int SHARDS_NUM_FIELD_NUMBER = 8;
    private int shardsNum_ = 0;
    public static final int ALIASES_FIELD_NUMBER = 9;
    private LazyStringArrayList aliases_ = LazyStringArrayList.emptyList();
    public static final int START_POSITIONS_FIELD_NUMBER = 10;
    private List<KeyDataPair> startPositions_;
    public static final int CONSISTENCY_LEVEL_FIELD_NUMBER = 11;
    private int consistencyLevel_ = 0;
    public static final int COLLECTION_NAME_FIELD_NUMBER = 12;
    private volatile Object collectionName_ = "";
    public static final int PROPERTIES_FIELD_NUMBER = 13;
    private List<KeyValuePair> properties_;
    public static final int DB_NAME_FIELD_NUMBER = 14;
    private volatile Object dbName_ = "";
    public static final int NUM_PARTITIONS_FIELD_NUMBER = 15;
    private long numPartitions_ = 0L;
    public static final int DB_ID_FIELD_NUMBER = 16;
    private long dbId_ = 0L;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DescribeCollectionResponse DEFAULT_INSTANCE = new DescribeCollectionResponse();
    private static final Parser<DescribeCollectionResponse> PARSER = new AbstractParser<DescribeCollectionResponse>(){

        public DescribeCollectionResponse parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DescribeCollectionResponse.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DescribeCollectionResponse(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DescribeCollectionResponse() {
        this.virtualChannelNames_ = LazyStringArrayList.emptyList();
        this.physicalChannelNames_ = LazyStringArrayList.emptyList();
        this.aliases_ = LazyStringArrayList.emptyList();
        this.startPositions_ = Collections.emptyList();
        this.consistencyLevel_ = 0;
        this.collectionName_ = "";
        this.properties_ = Collections.emptyList();
        this.dbName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DescribeCollectionResponse();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MilvusProto.internal_static_milvus_proto_milvus_DescribeCollectionResponse_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MilvusProto.internal_static_milvus_proto_milvus_DescribeCollectionResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(DescribeCollectionResponse.class, Builder.class);
    }

    @Override
    public boolean hasStatus() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Status getStatus() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public StatusOrBuilder getStatusOrBuilder() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public boolean hasSchema() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public CollectionSchema getSchema() {
        return this.schema_ == null ? CollectionSchema.getDefaultInstance() : this.schema_;
    }

    @Override
    public CollectionSchemaOrBuilder getSchemaOrBuilder() {
        return this.schema_ == null ? CollectionSchema.getDefaultInstance() : this.schema_;
    }

    @Override
    public long getCollectionID() {
        return this.collectionID_;
    }

    public ProtocolStringList getVirtualChannelNamesList() {
        return this.virtualChannelNames_;
    }

    @Override
    public int getVirtualChannelNamesCount() {
        return this.virtualChannelNames_.size();
    }

    @Override
    public String getVirtualChannelNames(int index) {
        return this.virtualChannelNames_.get(index);
    }

    @Override
    public ByteString getVirtualChannelNamesBytes(int index) {
        return this.virtualChannelNames_.getByteString(index);
    }

    public ProtocolStringList getPhysicalChannelNamesList() {
        return this.physicalChannelNames_;
    }

    @Override
    public int getPhysicalChannelNamesCount() {
        return this.physicalChannelNames_.size();
    }

    @Override
    public String getPhysicalChannelNames(int index) {
        return this.physicalChannelNames_.get(index);
    }

    @Override
    public ByteString getPhysicalChannelNamesBytes(int index) {
        return this.physicalChannelNames_.getByteString(index);
    }

    @Override
    public long getCreatedTimestamp() {
        return this.createdTimestamp_;
    }

    @Override
    public long getCreatedUtcTimestamp() {
        return this.createdUtcTimestamp_;
    }

    @Override
    public int getShardsNum() {
        return this.shardsNum_;
    }

    public ProtocolStringList getAliasesList() {
        return this.aliases_;
    }

    @Override
    public int getAliasesCount() {
        return this.aliases_.size();
    }

    @Override
    public String getAliases(int index) {
        return this.aliases_.get(index);
    }

    @Override
    public ByteString getAliasesBytes(int index) {
        return this.aliases_.getByteString(index);
    }

    @Override
    public List<KeyDataPair> getStartPositionsList() {
        return this.startPositions_;
    }

    @Override
    public List<? extends KeyDataPairOrBuilder> getStartPositionsOrBuilderList() {
        return this.startPositions_;
    }

    @Override
    public int getStartPositionsCount() {
        return this.startPositions_.size();
    }

    @Override
    public KeyDataPair getStartPositions(int index) {
        return this.startPositions_.get(index);
    }

    @Override
    public KeyDataPairOrBuilder getStartPositionsOrBuilder(int index) {
        return this.startPositions_.get(index);
    }

    @Override
    public int getConsistencyLevelValue() {
        return this.consistencyLevel_;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        ConsistencyLevel result = ConsistencyLevel.forNumber(this.consistencyLevel_);
        return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
    }

    @Override
    public String getCollectionName() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.collectionName_ = s;
        return s;
    }

    @Override
    public ByteString getCollectionNameBytes() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.collectionName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<KeyValuePair> getPropertiesList() {
        return this.properties_;
    }

    @Override
    public List<? extends KeyValuePairOrBuilder> getPropertiesOrBuilderList() {
        return this.properties_;
    }

    @Override
    public int getPropertiesCount() {
        return this.properties_.size();
    }

    @Override
    public KeyValuePair getProperties(int index) {
        return this.properties_.get(index);
    }

    @Override
    public KeyValuePairOrBuilder getPropertiesOrBuilder(int index) {
        return this.properties_.get(index);
    }

    @Override
    public String getDbName() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dbName_ = s;
        return s;
    }

    @Override
    public ByteString getDbNameBytes() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dbName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getNumPartitions() {
        return this.numPartitions_;
    }

    @Override
    public long getDbId() {
        return this.dbId_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getStatus());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(2, (MessageLite)this.getSchema());
        }
        if (this.collectionID_ != 0L) {
            output.writeInt64(3, this.collectionID_);
        }
        for (i = 0; i < this.virtualChannelNames_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.virtualChannelNames_.getRaw(i));
        }
        for (i = 0; i < this.physicalChannelNames_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.physicalChannelNames_.getRaw(i));
        }
        if (this.createdTimestamp_ != 0L) {
            output.writeUInt64(6, this.createdTimestamp_);
        }
        if (this.createdUtcTimestamp_ != 0L) {
            output.writeUInt64(7, this.createdUtcTimestamp_);
        }
        if (this.shardsNum_ != 0) {
            output.writeInt32(8, this.shardsNum_);
        }
        for (i = 0; i < this.aliases_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.aliases_.getRaw(i));
        }
        for (i = 0; i < this.startPositions_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.startPositions_.get(i));
        }
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            output.writeEnum(11, this.consistencyLevel_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.collectionName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.collectionName_);
        }
        for (i = 0; i < this.properties_.size(); ++i) {
            output.writeMessage(13, (MessageLite)this.properties_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dbName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.dbName_);
        }
        if (this.numPartitions_ != 0L) {
            output.writeInt64(15, this.numPartitions_);
        }
        if (this.dbId_ != 0L) {
            output.writeInt64(16, this.dbId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getStatus());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getSchema());
        }
        if (this.collectionID_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.collectionID_);
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.virtualChannelNames_.size(); ++i2) {
            dataSize += DescribeCollectionResponse.computeStringSizeNoTag((Object)this.virtualChannelNames_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getVirtualChannelNamesList().size();
        dataSize = 0;
        for (i2 = 0; i2 < this.physicalChannelNames_.size(); ++i2) {
            dataSize += DescribeCollectionResponse.computeStringSizeNoTag((Object)this.physicalChannelNames_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getPhysicalChannelNamesList().size();
        if (this.createdTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)6, (long)this.createdTimestamp_);
        }
        if (this.createdUtcTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)7, (long)this.createdUtcTimestamp_);
        }
        if (this.shardsNum_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.shardsNum_);
        }
        dataSize = 0;
        for (i2 = 0; i2 < this.aliases_.size(); ++i2) {
            dataSize += DescribeCollectionResponse.computeStringSizeNoTag((Object)this.aliases_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getAliasesList().size();
        for (i = 0; i < this.startPositions_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.startPositions_.get(i)));
        }
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.consistencyLevel_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.collectionName_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.collectionName_);
        }
        for (i = 0; i < this.properties_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)((MessageLite)this.properties_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dbName_)) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.dbName_);
        }
        if (this.numPartitions_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)15, (long)this.numPartitions_);
        }
        if (this.dbId_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)16, (long)this.dbId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DescribeCollectionResponse)) {
            return super.equals(obj);
        }
        DescribeCollectionResponse other = (DescribeCollectionResponse)obj;
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && !this.getStatus().equals(other.getStatus())) {
            return false;
        }
        if (this.hasSchema() != other.hasSchema()) {
            return false;
        }
        if (this.hasSchema() && !this.getSchema().equals(other.getSchema())) {
            return false;
        }
        if (this.getCollectionID() != other.getCollectionID()) {
            return false;
        }
        if (!this.getVirtualChannelNamesList().equals(other.getVirtualChannelNamesList())) {
            return false;
        }
        if (!this.getPhysicalChannelNamesList().equals(other.getPhysicalChannelNamesList())) {
            return false;
        }
        if (this.getCreatedTimestamp() != other.getCreatedTimestamp()) {
            return false;
        }
        if (this.getCreatedUtcTimestamp() != other.getCreatedUtcTimestamp()) {
            return false;
        }
        if (this.getShardsNum() != other.getShardsNum()) {
            return false;
        }
        if (!this.getAliasesList().equals(other.getAliasesList())) {
            return false;
        }
        if (!this.getStartPositionsList().equals(other.getStartPositionsList())) {
            return false;
        }
        if (this.consistencyLevel_ != other.consistencyLevel_) {
            return false;
        }
        if (!this.getCollectionName().equals(other.getCollectionName())) {
            return false;
        }
        if (!this.getPropertiesList().equals(other.getPropertiesList())) {
            return false;
        }
        if (!this.getDbName().equals(other.getDbName())) {
            return false;
        }
        if (this.getNumPartitions() != other.getNumPartitions()) {
            return false;
        }
        if (this.getDbId() != other.getDbId()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DescribeCollectionResponse.getDescriptor().hashCode();
        if (this.hasStatus()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getStatus().hashCode();
        }
        if (this.hasSchema()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getSchema().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getCollectionID());
        if (this.getVirtualChannelNamesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getVirtualChannelNamesList().hashCode();
        }
        if (this.getPhysicalChannelNamesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPhysicalChannelNamesList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashLong((long)this.getCreatedTimestamp());
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong((long)this.getCreatedUtcTimestamp());
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getShardsNum();
        if (this.getAliasesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAliasesList().hashCode();
        }
        if (this.getStartPositionsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getStartPositionsList().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.consistencyLevel_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getCollectionName().hashCode();
        if (this.getPropertiesCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getPropertiesList().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + this.getDbName().hashCode();
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashLong((long)this.getNumPartitions());
        hash = 37 * hash + 16;
        hash = 53 * hash + Internal.hashLong((long)this.getDbId());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DescribeCollectionResponse parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data);
    }

    public static DescribeCollectionResponse parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DescribeCollectionResponse parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data);
    }

    public static DescribeCollectionResponse parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DescribeCollectionResponse parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data);
    }

    public static DescribeCollectionResponse parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DescribeCollectionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DescribeCollectionResponse parseFrom(InputStream input) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DescribeCollectionResponse parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DescribeCollectionResponse parseDelimitedFrom(InputStream input) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DescribeCollectionResponse parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DescribeCollectionResponse parseFrom(CodedInputStream input) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DescribeCollectionResponse parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DescribeCollectionResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DescribeCollectionResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DescribeCollectionResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DescribeCollectionResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DescribeCollectionResponse> parser() {
        return PARSER;
    }

    public Parser<DescribeCollectionResponse> getParserForType() {
        return PARSER;
    }

    public DescribeCollectionResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DescribeCollectionResponseOrBuilder {
        private int bitField0_;
        private Status status_;
        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> statusBuilder_;
        private CollectionSchema schema_;
        private SingleFieldBuilderV3<CollectionSchema, CollectionSchema.Builder, CollectionSchemaOrBuilder> schemaBuilder_;
        private long collectionID_;
        private LazyStringArrayList virtualChannelNames_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList physicalChannelNames_ = LazyStringArrayList.emptyList();
        private long createdTimestamp_;
        private long createdUtcTimestamp_;
        private int shardsNum_;
        private LazyStringArrayList aliases_ = LazyStringArrayList.emptyList();
        private List<KeyDataPair> startPositions_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyDataPair, KeyDataPair.Builder, KeyDataPairOrBuilder> startPositionsBuilder_;
        private int consistencyLevel_ = 0;
        private Object collectionName_ = "";
        private List<KeyValuePair> properties_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> propertiesBuilder_;
        private Object dbName_ = "";
        private long numPartitions_;
        private long dbId_;

        public static final Descriptors.Descriptor getDescriptor() {
            return MilvusProto.internal_static_milvus_proto_milvus_DescribeCollectionResponse_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MilvusProto.internal_static_milvus_proto_milvus_DescribeCollectionResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(DescribeCollectionResponse.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getStatusFieldBuilder();
                this.getSchemaFieldBuilder();
                this.getStartPositionsFieldBuilder();
                this.getPropertiesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.schema_ = null;
            if (this.schemaBuilder_ != null) {
                this.schemaBuilder_.dispose();
                this.schemaBuilder_ = null;
            }
            this.collectionID_ = 0L;
            this.virtualChannelNames_ = LazyStringArrayList.emptyList();
            this.physicalChannelNames_ = LazyStringArrayList.emptyList();
            this.createdTimestamp_ = 0L;
            this.createdUtcTimestamp_ = 0L;
            this.shardsNum_ = 0;
            this.aliases_ = LazyStringArrayList.emptyList();
            if (this.startPositionsBuilder_ == null) {
                this.startPositions_ = Collections.emptyList();
            } else {
                this.startPositions_ = null;
                this.startPositionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.consistencyLevel_ = 0;
            this.collectionName_ = "";
            if (this.propertiesBuilder_ == null) {
                this.properties_ = Collections.emptyList();
            } else {
                this.properties_ = null;
                this.propertiesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFEFFF;
            this.dbName_ = "";
            this.numPartitions_ = 0L;
            this.dbId_ = 0L;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MilvusProto.internal_static_milvus_proto_milvus_DescribeCollectionResponse_descriptor;
        }

        public DescribeCollectionResponse getDefaultInstanceForType() {
            return DescribeCollectionResponse.getDefaultInstance();
        }

        public DescribeCollectionResponse build() {
            DescribeCollectionResponse result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DescribeCollectionResponse buildPartial() {
            DescribeCollectionResponse result = new DescribeCollectionResponse(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(DescribeCollectionResponse result) {
            if (this.startPositionsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.startPositions_ = Collections.unmodifiableList(this.startPositions_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.startPositions_ = this.startPositions_;
            } else {
                result.startPositions_ = this.startPositionsBuilder_.build();
            }
            if (this.propertiesBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0) {
                    this.properties_ = Collections.unmodifiableList(this.properties_);
                    this.bitField0_ &= 0xFFFFEFFF;
                }
                result.properties_ = this.properties_;
            } else {
                result.properties_ = this.propertiesBuilder_.build();
            }
        }

        private void buildPartial0(DescribeCollectionResponse result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.status_ = this.statusBuilder_ == null ? this.status_ : (Status)this.statusBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.schema_ = this.schemaBuilder_ == null ? this.schema_ : (CollectionSchema)this.schemaBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.collectionID_ = this.collectionID_;
            }
            if ((from_bitField0_ & 8) != 0) {
                this.virtualChannelNames_.makeImmutable();
                result.virtualChannelNames_ = this.virtualChannelNames_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.physicalChannelNames_.makeImmutable();
                result.physicalChannelNames_ = this.physicalChannelNames_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.createdTimestamp_ = this.createdTimestamp_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.createdUtcTimestamp_ = this.createdUtcTimestamp_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.shardsNum_ = this.shardsNum_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.aliases_.makeImmutable();
                result.aliases_ = this.aliases_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.consistencyLevel_ = this.consistencyLevel_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.collectionName_ = this.collectionName_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.dbName_ = this.dbName_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.numPartitions_ = this.numPartitions_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.dbId_ = this.dbId_;
            }
            DescribeCollectionResponse describeCollectionResponse = result;
            describeCollectionResponse.bitField0_ = describeCollectionResponse.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DescribeCollectionResponse) {
                return this.mergeFrom((DescribeCollectionResponse)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DescribeCollectionResponse other) {
            if (other == DescribeCollectionResponse.getDefaultInstance()) {
                return this;
            }
            if (other.hasStatus()) {
                this.mergeStatus(other.getStatus());
            }
            if (other.hasSchema()) {
                this.mergeSchema(other.getSchema());
            }
            if (other.getCollectionID() != 0L) {
                this.setCollectionID(other.getCollectionID());
            }
            if (!other.virtualChannelNames_.isEmpty()) {
                if (this.virtualChannelNames_.isEmpty()) {
                    this.virtualChannelNames_ = other.virtualChannelNames_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensureVirtualChannelNamesIsMutable();
                    this.virtualChannelNames_.addAll((Collection)other.virtualChannelNames_);
                }
                this.onChanged();
            }
            if (!other.physicalChannelNames_.isEmpty()) {
                if (this.physicalChannelNames_.isEmpty()) {
                    this.physicalChannelNames_ = other.physicalChannelNames_;
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensurePhysicalChannelNamesIsMutable();
                    this.physicalChannelNames_.addAll((Collection)other.physicalChannelNames_);
                }
                this.onChanged();
            }
            if (other.getCreatedTimestamp() != 0L) {
                this.setCreatedTimestamp(other.getCreatedTimestamp());
            }
            if (other.getCreatedUtcTimestamp() != 0L) {
                this.setCreatedUtcTimestamp(other.getCreatedUtcTimestamp());
            }
            if (other.getShardsNum() != 0) {
                this.setShardsNum(other.getShardsNum());
            }
            if (!other.aliases_.isEmpty()) {
                if (this.aliases_.isEmpty()) {
                    this.aliases_ = other.aliases_;
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureAliasesIsMutable();
                    this.aliases_.addAll((Collection)other.aliases_);
                }
                this.onChanged();
            }
            if (this.startPositionsBuilder_ == null) {
                if (!other.startPositions_.isEmpty()) {
                    if (this.startPositions_.isEmpty()) {
                        this.startPositions_ = other.startPositions_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureStartPositionsIsMutable();
                        this.startPositions_.addAll(other.startPositions_);
                    }
                    this.onChanged();
                }
            } else if (!other.startPositions_.isEmpty()) {
                if (this.startPositionsBuilder_.isEmpty()) {
                    this.startPositionsBuilder_.dispose();
                    this.startPositionsBuilder_ = null;
                    this.startPositions_ = other.startPositions_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.startPositionsBuilder_ = alwaysUseFieldBuilders ? this.getStartPositionsFieldBuilder() : null;
                } else {
                    this.startPositionsBuilder_.addAllMessages((Iterable)other.startPositions_);
                }
            }
            if (other.consistencyLevel_ != 0) {
                this.setConsistencyLevelValue(other.getConsistencyLevelValue());
            }
            if (!other.getCollectionName().isEmpty()) {
                this.collectionName_ = other.collectionName_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (this.propertiesBuilder_ == null) {
                if (!other.properties_.isEmpty()) {
                    if (this.properties_.isEmpty()) {
                        this.properties_ = other.properties_;
                        this.bitField0_ &= 0xFFFFEFFF;
                    } else {
                        this.ensurePropertiesIsMutable();
                        this.properties_.addAll(other.properties_);
                    }
                    this.onChanged();
                }
            } else if (!other.properties_.isEmpty()) {
                if (this.propertiesBuilder_.isEmpty()) {
                    this.propertiesBuilder_.dispose();
                    this.propertiesBuilder_ = null;
                    this.properties_ = other.properties_;
                    this.bitField0_ &= 0xFFFFEFFF;
                    this.propertiesBuilder_ = alwaysUseFieldBuilders ? this.getPropertiesFieldBuilder() : null;
                } else {
                    this.propertiesBuilder_.addAllMessages((Iterable)other.properties_);
                }
            }
            if (!other.getDbName().isEmpty()) {
                this.dbName_ = other.dbName_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (other.getNumPartitions() != 0L) {
                this.setNumPartitions(other.getNumPartitions());
            }
            if (other.getDbId() != 0L) {
                this.setDbId(other.getDbId());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block24: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block24;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block24;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getSchemaFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block24;
                        }
                        case 24: {
                            this.collectionID_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block24;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureVirtualChannelNamesIsMutable();
                            this.virtualChannelNames_.add((Object)s);
                            continue block24;
                        }
                        case 42: {
                            String s = input.readStringRequireUtf8();
                            this.ensurePhysicalChannelNamesIsMutable();
                            this.physicalChannelNames_.add((Object)s);
                            continue block24;
                        }
                        case 48: {
                            this.createdTimestamp_ = input.readUInt64();
                            this.bitField0_ |= 0x20;
                            continue block24;
                        }
                        case 56: {
                            this.createdUtcTimestamp_ = input.readUInt64();
                            this.bitField0_ |= 0x40;
                            continue block24;
                        }
                        case 64: {
                            this.shardsNum_ = input.readInt32();
                            this.bitField0_ |= 0x80;
                            continue block24;
                        }
                        case 74: {
                            String s = input.readStringRequireUtf8();
                            this.ensureAliasesIsMutable();
                            this.aliases_.add((Object)s);
                            continue block24;
                        }
                        case 82: {
                            GeneratedMessageV3 m = (KeyDataPair)input.readMessage(KeyDataPair.parser(), extensionRegistry);
                            if (this.startPositionsBuilder_ == null) {
                                this.ensureStartPositionsIsMutable();
                                this.startPositions_.add((KeyDataPair)m);
                                continue block24;
                            }
                            this.startPositionsBuilder_.addMessage((AbstractMessage)m);
                            continue block24;
                        }
                        case 88: {
                            this.consistencyLevel_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block24;
                        }
                        case 98: {
                            this.collectionName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block24;
                        }
                        case 106: {
                            GeneratedMessageV3 m = (KeyValuePair)input.readMessage(KeyValuePair.parser(), extensionRegistry);
                            if (this.propertiesBuilder_ == null) {
                                this.ensurePropertiesIsMutable();
                                this.properties_.add((KeyValuePair)m);
                                continue block24;
                            }
                            this.propertiesBuilder_.addMessage((AbstractMessage)m);
                            continue block24;
                        }
                        case 114: {
                            this.dbName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block24;
                        }
                        case 120: {
                            this.numPartitions_ = input.readInt64();
                            this.bitField0_ |= 0x4000;
                            continue block24;
                        }
                        case 128: {
                            this.dbId_ = input.readInt64();
                            this.bitField0_ |= 0x8000;
                            continue block24;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasStatus() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Status getStatus() {
            if (this.statusBuilder_ == null) {
                return this.status_ == null ? Status.getDefaultInstance() : this.status_;
            }
            return (Status)this.statusBuilder_.getMessage();
        }

        public Builder setStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.status_ = value;
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setStatus(Status.Builder builderForValue) {
            if (this.statusBuilder_ == null) {
                this.status_ = builderForValue.build();
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.status_ != null && this.status_ != Status.getDefaultInstance()) {
                    this.getStatusBuilder().mergeFrom(value);
                } else {
                    this.status_ = value;
                }
            } else {
                this.statusBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.status_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Status.Builder getStatusBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (Status.Builder)this.getStatusFieldBuilder().getBuilder();
        }

        @Override
        public StatusOrBuilder getStatusOrBuilder() {
            if (this.statusBuilder_ != null) {
                return (StatusOrBuilder)this.statusBuilder_.getMessageOrBuilder();
            }
            return this.status_ == null ? Status.getDefaultInstance() : this.status_;
        }

        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getStatusFieldBuilder() {
            if (this.statusBuilder_ == null) {
                this.statusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.status_ = null;
            }
            return this.statusBuilder_;
        }

        @Override
        public boolean hasSchema() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public CollectionSchema getSchema() {
            if (this.schemaBuilder_ == null) {
                return this.schema_ == null ? CollectionSchema.getDefaultInstance() : this.schema_;
            }
            return (CollectionSchema)this.schemaBuilder_.getMessage();
        }

        public Builder setSchema(CollectionSchema value) {
            if (this.schemaBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.schema_ = value;
            } else {
                this.schemaBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setSchema(CollectionSchema.Builder builderForValue) {
            if (this.schemaBuilder_ == null) {
                this.schema_ = builderForValue.build();
            } else {
                this.schemaBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeSchema(CollectionSchema value) {
            if (this.schemaBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.schema_ != null && this.schema_ != CollectionSchema.getDefaultInstance()) {
                    this.getSchemaBuilder().mergeFrom(value);
                } else {
                    this.schema_ = value;
                }
            } else {
                this.schemaBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.schema_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSchema() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.schema_ = null;
            if (this.schemaBuilder_ != null) {
                this.schemaBuilder_.dispose();
                this.schemaBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CollectionSchema.Builder getSchemaBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (CollectionSchema.Builder)this.getSchemaFieldBuilder().getBuilder();
        }

        @Override
        public CollectionSchemaOrBuilder getSchemaOrBuilder() {
            if (this.schemaBuilder_ != null) {
                return (CollectionSchemaOrBuilder)this.schemaBuilder_.getMessageOrBuilder();
            }
            return this.schema_ == null ? CollectionSchema.getDefaultInstance() : this.schema_;
        }

        private SingleFieldBuilderV3<CollectionSchema, CollectionSchema.Builder, CollectionSchemaOrBuilder> getSchemaFieldBuilder() {
            if (this.schemaBuilder_ == null) {
                this.schemaBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSchema(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.schema_ = null;
            }
            return this.schemaBuilder_;
        }

        @Override
        public long getCollectionID() {
            return this.collectionID_;
        }

        public Builder setCollectionID(long value) {
            this.collectionID_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearCollectionID() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.collectionID_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureVirtualChannelNamesIsMutable() {
            if (!this.virtualChannelNames_.isModifiable()) {
                this.virtualChannelNames_ = new LazyStringArrayList((LazyStringList)this.virtualChannelNames_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getVirtualChannelNamesList() {
            this.virtualChannelNames_.makeImmutable();
            return this.virtualChannelNames_;
        }

        @Override
        public int getVirtualChannelNamesCount() {
            return this.virtualChannelNames_.size();
        }

        @Override
        public String getVirtualChannelNames(int index) {
            return this.virtualChannelNames_.get(index);
        }

        @Override
        public ByteString getVirtualChannelNamesBytes(int index) {
            return this.virtualChannelNames_.getByteString(index);
        }

        public Builder setVirtualChannelNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureVirtualChannelNamesIsMutable();
            this.virtualChannelNames_.set(index, value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addVirtualChannelNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureVirtualChannelNamesIsMutable();
            this.virtualChannelNames_.add((Object)value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllVirtualChannelNames(Iterable<String> values) {
            this.ensureVirtualChannelNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.virtualChannelNames_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearVirtualChannelNames() {
            this.virtualChannelNames_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addVirtualChannelNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DescribeCollectionResponse.checkByteStringIsUtf8((ByteString)value);
            this.ensureVirtualChannelNamesIsMutable();
            this.virtualChannelNames_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensurePhysicalChannelNamesIsMutable() {
            if (!this.physicalChannelNames_.isModifiable()) {
                this.physicalChannelNames_ = new LazyStringArrayList((LazyStringList)this.physicalChannelNames_);
            }
            this.bitField0_ |= 0x10;
        }

        public ProtocolStringList getPhysicalChannelNamesList() {
            this.physicalChannelNames_.makeImmutable();
            return this.physicalChannelNames_;
        }

        @Override
        public int getPhysicalChannelNamesCount() {
            return this.physicalChannelNames_.size();
        }

        @Override
        public String getPhysicalChannelNames(int index) {
            return this.physicalChannelNames_.get(index);
        }

        @Override
        public ByteString getPhysicalChannelNamesBytes(int index) {
            return this.physicalChannelNames_.getByteString(index);
        }

        public Builder setPhysicalChannelNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePhysicalChannelNamesIsMutable();
            this.physicalChannelNames_.set(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addPhysicalChannelNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePhysicalChannelNamesIsMutable();
            this.physicalChannelNames_.add((Object)value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllPhysicalChannelNames(Iterable<String> values) {
            this.ensurePhysicalChannelNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.physicalChannelNames_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPhysicalChannelNames() {
            this.physicalChannelNames_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addPhysicalChannelNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DescribeCollectionResponse.checkByteStringIsUtf8((ByteString)value);
            this.ensurePhysicalChannelNamesIsMutable();
            this.physicalChannelNames_.add(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public long getCreatedTimestamp() {
            return this.createdTimestamp_;
        }

        public Builder setCreatedTimestamp(long value) {
            this.createdTimestamp_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearCreatedTimestamp() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.createdTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getCreatedUtcTimestamp() {
            return this.createdUtcTimestamp_;
        }

        public Builder setCreatedUtcTimestamp(long value) {
            this.createdUtcTimestamp_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearCreatedUtcTimestamp() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.createdUtcTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getShardsNum() {
            return this.shardsNum_;
        }

        public Builder setShardsNum(int value) {
            this.shardsNum_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearShardsNum() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.shardsNum_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureAliasesIsMutable() {
            if (!this.aliases_.isModifiable()) {
                this.aliases_ = new LazyStringArrayList((LazyStringList)this.aliases_);
            }
            this.bitField0_ |= 0x100;
        }

        public ProtocolStringList getAliasesList() {
            this.aliases_.makeImmutable();
            return this.aliases_;
        }

        @Override
        public int getAliasesCount() {
            return this.aliases_.size();
        }

        @Override
        public String getAliases(int index) {
            return this.aliases_.get(index);
        }

        @Override
        public ByteString getAliasesBytes(int index) {
            return this.aliases_.getByteString(index);
        }

        public Builder setAliases(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAliasesIsMutable();
            this.aliases_.set(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAliases(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAliasesIsMutable();
            this.aliases_.add((Object)value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllAliases(Iterable<String> values) {
            this.ensureAliasesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.aliases_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearAliases() {
            this.aliases_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addAliasesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DescribeCollectionResponse.checkByteStringIsUtf8((ByteString)value);
            this.ensureAliasesIsMutable();
            this.aliases_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureStartPositionsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.startPositions_ = new ArrayList<KeyDataPair>(this.startPositions_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<KeyDataPair> getStartPositionsList() {
            if (this.startPositionsBuilder_ == null) {
                return Collections.unmodifiableList(this.startPositions_);
            }
            return this.startPositionsBuilder_.getMessageList();
        }

        @Override
        public int getStartPositionsCount() {
            if (this.startPositionsBuilder_ == null) {
                return this.startPositions_.size();
            }
            return this.startPositionsBuilder_.getCount();
        }

        @Override
        public KeyDataPair getStartPositions(int index) {
            if (this.startPositionsBuilder_ == null) {
                return this.startPositions_.get(index);
            }
            return (KeyDataPair)this.startPositionsBuilder_.getMessage(index);
        }

        public Builder setStartPositions(int index, KeyDataPair value) {
            if (this.startPositionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartPositionsIsMutable();
                this.startPositions_.set(index, value);
                this.onChanged();
            } else {
                this.startPositionsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setStartPositions(int index, KeyDataPair.Builder builderForValue) {
            if (this.startPositionsBuilder_ == null) {
                this.ensureStartPositionsIsMutable();
                this.startPositions_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.startPositionsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStartPositions(KeyDataPair value) {
            if (this.startPositionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartPositionsIsMutable();
                this.startPositions_.add(value);
                this.onChanged();
            } else {
                this.startPositionsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addStartPositions(int index, KeyDataPair value) {
            if (this.startPositionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartPositionsIsMutable();
                this.startPositions_.add(index, value);
                this.onChanged();
            } else {
                this.startPositionsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addStartPositions(KeyDataPair.Builder builderForValue) {
            if (this.startPositionsBuilder_ == null) {
                this.ensureStartPositionsIsMutable();
                this.startPositions_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.startPositionsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStartPositions(int index, KeyDataPair.Builder builderForValue) {
            if (this.startPositionsBuilder_ == null) {
                this.ensureStartPositionsIsMutable();
                this.startPositions_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.startPositionsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllStartPositions(Iterable<? extends KeyDataPair> values) {
            if (this.startPositionsBuilder_ == null) {
                this.ensureStartPositionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.startPositions_);
                this.onChanged();
            } else {
                this.startPositionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearStartPositions() {
            if (this.startPositionsBuilder_ == null) {
                this.startPositions_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.startPositionsBuilder_.clear();
            }
            return this;
        }

        public Builder removeStartPositions(int index) {
            if (this.startPositionsBuilder_ == null) {
                this.ensureStartPositionsIsMutable();
                this.startPositions_.remove(index);
                this.onChanged();
            } else {
                this.startPositionsBuilder_.remove(index);
            }
            return this;
        }

        public KeyDataPair.Builder getStartPositionsBuilder(int index) {
            return (KeyDataPair.Builder)this.getStartPositionsFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyDataPairOrBuilder getStartPositionsOrBuilder(int index) {
            if (this.startPositionsBuilder_ == null) {
                return this.startPositions_.get(index);
            }
            return (KeyDataPairOrBuilder)this.startPositionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyDataPairOrBuilder> getStartPositionsOrBuilderList() {
            if (this.startPositionsBuilder_ != null) {
                return this.startPositionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.startPositions_);
        }

        public KeyDataPair.Builder addStartPositionsBuilder() {
            return (KeyDataPair.Builder)this.getStartPositionsFieldBuilder().addBuilder((AbstractMessage)KeyDataPair.getDefaultInstance());
        }

        public KeyDataPair.Builder addStartPositionsBuilder(int index) {
            return (KeyDataPair.Builder)this.getStartPositionsFieldBuilder().addBuilder(index, (AbstractMessage)KeyDataPair.getDefaultInstance());
        }

        public List<KeyDataPair.Builder> getStartPositionsBuilderList() {
            return this.getStartPositionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyDataPair, KeyDataPair.Builder, KeyDataPairOrBuilder> getStartPositionsFieldBuilder() {
            if (this.startPositionsBuilder_ == null) {
                this.startPositionsBuilder_ = new RepeatedFieldBuilderV3(this.startPositions_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startPositions_ = null;
            }
            return this.startPositionsBuilder_;
        }

        @Override
        public int getConsistencyLevelValue() {
            return this.consistencyLevel_;
        }

        public Builder setConsistencyLevelValue(int value) {
            this.consistencyLevel_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            ConsistencyLevel result = ConsistencyLevel.forNumber(this.consistencyLevel_);
            return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
        }

        public Builder setConsistencyLevel(ConsistencyLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.consistencyLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConsistencyLevel() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.consistencyLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getCollectionName() {
            Object ref = this.collectionName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.collectionName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCollectionNameBytes() {
            Object ref = this.collectionName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.collectionName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCollectionName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.collectionName_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearCollectionName() {
            this.collectionName_ = DescribeCollectionResponse.getDefaultInstance().getCollectionName();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setCollectionNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DescribeCollectionResponse.checkByteStringIsUtf8((ByteString)value);
            this.collectionName_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        private void ensurePropertiesIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.properties_ = new ArrayList<KeyValuePair>(this.properties_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<KeyValuePair> getPropertiesList() {
            if (this.propertiesBuilder_ == null) {
                return Collections.unmodifiableList(this.properties_);
            }
            return this.propertiesBuilder_.getMessageList();
        }

        @Override
        public int getPropertiesCount() {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.size();
            }
            return this.propertiesBuilder_.getCount();
        }

        @Override
        public KeyValuePair getProperties(int index) {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.get(index);
            }
            return (KeyValuePair)this.propertiesBuilder_.getMessage(index);
        }

        public Builder setProperties(int index, KeyValuePair value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.set(index, value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setProperties(int index, KeyValuePair.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProperties(KeyValuePair value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.add(value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addProperties(int index, KeyValuePair value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.add(index, value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addProperties(KeyValuePair.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProperties(int index, KeyValuePair.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllProperties(Iterable<? extends KeyValuePair> values) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.properties_);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearProperties() {
            if (this.propertiesBuilder_ == null) {
                this.properties_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
            } else {
                this.propertiesBuilder_.clear();
            }
            return this;
        }

        public Builder removeProperties(int index) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.remove(index);
                this.onChanged();
            } else {
                this.propertiesBuilder_.remove(index);
            }
            return this;
        }

        public KeyValuePair.Builder getPropertiesBuilder(int index) {
            return (KeyValuePair.Builder)this.getPropertiesFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValuePairOrBuilder getPropertiesOrBuilder(int index) {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.get(index);
            }
            return (KeyValuePairOrBuilder)this.propertiesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValuePairOrBuilder> getPropertiesOrBuilderList() {
            if (this.propertiesBuilder_ != null) {
                return this.propertiesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.properties_);
        }

        public KeyValuePair.Builder addPropertiesBuilder() {
            return (KeyValuePair.Builder)this.getPropertiesFieldBuilder().addBuilder((AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public KeyValuePair.Builder addPropertiesBuilder(int index) {
            return (KeyValuePair.Builder)this.getPropertiesFieldBuilder().addBuilder(index, (AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public List<KeyValuePair.Builder> getPropertiesBuilderList() {
            return this.getPropertiesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> getPropertiesFieldBuilder() {
            if (this.propertiesBuilder_ == null) {
                this.propertiesBuilder_ = new RepeatedFieldBuilderV3(this.properties_, (this.bitField0_ & 0x1000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.properties_ = null;
            }
            return this.propertiesBuilder_;
        }

        @Override
        public String getDbName() {
            Object ref = this.dbName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dbName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDbNameBytes() {
            Object ref = this.dbName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dbName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDbName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dbName_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearDbName() {
            this.dbName_ = DescribeCollectionResponse.getDefaultInstance().getDbName();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setDbNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DescribeCollectionResponse.checkByteStringIsUtf8((ByteString)value);
            this.dbName_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumPartitions() {
            return this.numPartitions_;
        }

        public Builder setNumPartitions(long value) {
            this.numPartitions_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearNumPartitions() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.numPartitions_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getDbId() {
            return this.dbId_;
        }

        public Builder setDbId(long value) {
            this.dbId_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearDbId() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.dbId_ = 0L;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

