/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.imfangs.dify.client.DifyDatasetsClient;
import io.github.imfangs.dify.client.exception.DifyApiException;
import io.github.imfangs.dify.client.impl.AbstractDifyClient;
import io.github.imfangs.dify.client.model.common.SimpleResponse;
import io.github.imfangs.dify.client.model.datasets.ChildChunkListResponse;
import io.github.imfangs.dify.client.model.datasets.ChildChunkResponse;
import io.github.imfangs.dify.client.model.datasets.CreateDatasetRequest;
import io.github.imfangs.dify.client.model.datasets.CreateDocumentByFileRequest;
import io.github.imfangs.dify.client.model.datasets.CreateDocumentByTextRequest;
import io.github.imfangs.dify.client.model.datasets.CreateMetadataRequest;
import io.github.imfangs.dify.client.model.datasets.CreateSegmentsRequest;
import io.github.imfangs.dify.client.model.datasets.CreateTagRequest;
import io.github.imfangs.dify.client.model.datasets.DatasetListResponse;
import io.github.imfangs.dify.client.model.datasets.DatasetResponse;
import io.github.imfangs.dify.client.model.datasets.DeleteTagRequest;
import io.github.imfangs.dify.client.model.datasets.DetailedDocumentResponse;
import io.github.imfangs.dify.client.model.datasets.DocMetadataListResponse;
import io.github.imfangs.dify.client.model.datasets.DocumentListResponse;
import io.github.imfangs.dify.client.model.datasets.DocumentResponse;
import io.github.imfangs.dify.client.model.datasets.EmbeddingModelListResponse;
import io.github.imfangs.dify.client.model.datasets.IndexingStatusResponse;
import io.github.imfangs.dify.client.model.datasets.MetadataResponse;
import io.github.imfangs.dify.client.model.datasets.OperationData;
import io.github.imfangs.dify.client.model.datasets.RetrieveRequest;
import io.github.imfangs.dify.client.model.datasets.RetrieveResponse;
import io.github.imfangs.dify.client.model.datasets.SaveChildChunkRequest;
import io.github.imfangs.dify.client.model.datasets.SegmentListResponse;
import io.github.imfangs.dify.client.model.datasets.SegmentResponse;
import io.github.imfangs.dify.client.model.datasets.TagBindRequest;
import io.github.imfangs.dify.client.model.datasets.TagListResponse;
import io.github.imfangs.dify.client.model.datasets.TagResponse;
import io.github.imfangs.dify.client.model.datasets.TagUnbindRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateDatasetRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateDocumentByFileRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateDocumentByTextRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateDocumentStatusRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateMetadataRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateSegmentRequest;
import io.github.imfangs.dify.client.model.datasets.UpdateTagRequest;
import io.github.imfangs.dify.client.model.datasets.UploadFileResponse;
import io.github.imfangs.dify.client.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDifyDatasetsClient
extends AbstractDifyClient
implements DifyDatasetsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDifyDatasetsClient.class);
    private static final String DATASETS_PATH = "/datasets";
    private static final String DOCUMENTS_PATH = "/documents";
    private static final String SEGMENTS_PATH = "/segments";
    private static final String CHILD_CHUNKS_PATH = "/child_chunks";
    private static final String DOCUMENT_CREATE_BY_TEXT_PATH = "/document/create-by-text";
    private static final String DOCUMENT_CREATE_BY_FILE_PATH = "/document/create-by-file";
    private static final String UPDATE_BY_TEXT_PATH = "/update-by-text";
    private static final String UPDATE_BY_FILE_PATH = "/update-by-file";
    private static final String INDEXING_STATUS_PATH = "/indexing-status";
    private static final String UPLOAD_FILE_PATH = "/upload-file";
    private static final String RETRIEVE_PATH = "/retrieve";
    private static final String METADATA_PATH = "/metadata";
    private static final String METADATA_BUILT_IN_PATH = "/metadata/built-in";
    private static final String DOCUMENT_METADATA_PATH = "/documents/metadata";
    private static final String EMBEDDING_MODEL_TYPES_PATH = "/workspaces/current/models/model-types/text-embedding";
    private static final String DOCUMENTS_STATUS_PATH = "/documents/status";
    private static final String TAGS_PATH = "/tags";
    private static final String TAGS_BINDING_PATH = "/tags/binding";
    private static final String TAGS_UNBINDING_PATH = "/tags/unbinding";

    public DefaultDifyDatasetsClient(String baseUrl, String apiKey) {
        super(baseUrl, apiKey);
    }

    public DefaultDifyDatasetsClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        super(baseUrl, apiKey, httpClient);
    }

    @Override
    public DatasetResponse createDataset(CreateDatasetRequest request) throws IOException, DifyApiException {
        return this.executePost(DATASETS_PATH, request, DatasetResponse.class);
    }

    @Override
    public DatasetListResponse getDatasets(Integer page, Integer limit) throws IOException, DifyApiException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        this.addIfNotNull(queryParams, "page", page);
        this.addIfNotNull(queryParams, "limit", limit);
        String url = this.buildUrlWithParams(DATASETS_PATH, queryParams);
        return this.executeGet(url, DatasetListResponse.class);
    }

    @Override
    public DatasetResponse getDataset(String datasetId) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId;
        return this.executeGet(path, DatasetResponse.class);
    }

    @Override
    public DatasetResponse updateDataset(String datasetId, UpdateDatasetRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId;
        return this.executePatch(path, request, DatasetResponse.class);
    }

    @Override
    public SimpleResponse deleteDataset(String datasetId) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId;
        Request httpRequest = this.createDeleteRequest(path, null);
        try (Response response = this.httpClient.newCall(httpRequest).execute();){
            if (response.code() == 204 || response.code() == 200) {
                SimpleResponse simpleResponse = new SimpleResponse();
                simpleResponse.setResult("success");
                SimpleResponse simpleResponse2 = simpleResponse;
                return simpleResponse2;
            }
            SimpleResponse simpleResponse = this.handleResponse(response, SimpleResponse.class);
            return simpleResponse;
        }
    }

    @Override
    public DocumentResponse createDocumentByText(String datasetId, CreateDocumentByTextRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + DOCUMENT_CREATE_BY_TEXT_PATH;
        return this.executePost(path, request, DocumentResponse.class);
    }

    @Override
    public DocumentResponse createDocumentByFile(String datasetId, CreateDocumentByFileRequest request, File file) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + DOCUMENT_CREATE_BY_FILE_PATH;
        MultipartBody.Builder multipartBuilder = this.createMultipartBuilder(request, file);
        return this.executeMultipartRequest(path, (RequestBody)multipartBuilder.build(), DocumentResponse.class);
    }

    @Override
    public DocumentResponse createDocumentByFile(String datasetId, CreateDocumentByFileRequest request, InputStream inputStream, String fileName) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + DOCUMENT_CREATE_BY_FILE_PATH;
        byte[] bytes = this.readAllBytes(inputStream);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("data", JsonUtils.toJson(request)).addFormDataPart("file", fileName, RequestBody.create((byte[])bytes, (MediaType)OCTET_STREAM));
        return this.executeMultipartRequest(path, (RequestBody)multipartBuilder.build(), DocumentResponse.class);
    }

    @Override
    public DocumentResponse updateDocumentByText(String datasetId, String documentId, UpdateDocumentByTextRequest request) throws IOException, DifyApiException {
        String path = this.buildDocumentPath(datasetId, documentId) + UPDATE_BY_TEXT_PATH;
        return this.executePost(path, request, DocumentResponse.class);
    }

    @Override
    public DocumentResponse updateDocumentByFile(String datasetId, String documentId, UpdateDocumentByFileRequest request, File file) throws IOException, DifyApiException {
        String path = this.buildDocumentPath(datasetId, documentId) + UPDATE_BY_FILE_PATH;
        MultipartBody.Builder multipartBuilder = this.createMultipartBuilder(request, file);
        return this.executeMultipartRequest(path, (RequestBody)multipartBuilder.build(), DocumentResponse.class);
    }

    @Override
    public IndexingStatusResponse getIndexingStatus(String datasetId, String batch) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + DOCUMENTS_PATH + "/" + batch + INDEXING_STATUS_PATH;
        return this.executeGet(path, IndexingStatusResponse.class);
    }

    @Override
    public void deleteDocument(String datasetId, String documentId) throws IOException, DifyApiException {
        String path = this.buildDocumentPath(datasetId, documentId);
        this.executeDelete(path, null, Object.class);
    }

    @Override
    public DocumentListResponse getDocuments(String datasetId, String keyword, Integer page, Integer limit) throws IOException, DifyApiException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        this.addIfNotEmpty(queryParams, "keyword", keyword);
        this.addIfNotNull(queryParams, "page", page);
        this.addIfNotNull(queryParams, "limit", limit);
        String path = "/datasets/" + datasetId + DOCUMENTS_PATH;
        String url = this.buildUrlWithParams(path, queryParams);
        return this.executeGet(url, DocumentListResponse.class);
    }

    @Override
    public DetailedDocumentResponse getDocumentDetail(String datasetId, String documentId, String metadata) throws IOException, DifyApiException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        this.addIfNotEmpty(queryParams, "metadata", metadata);
        String path = this.buildDocumentPath(datasetId, documentId);
        String url = this.buildUrlWithParams(path, queryParams);
        return this.executeGet(url, DetailedDocumentResponse.class);
    }

    @Override
    public SimpleResponse updateDocumentStatus(String datasetId, String action, UpdateDocumentStatusRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + DOCUMENTS_STATUS_PATH + "/" + action;
        return this.executePatch(path, request, SimpleResponse.class);
    }

    @Override
    public SegmentListResponse createSegments(String datasetId, String documentId, CreateSegmentsRequest request) throws IOException, DifyApiException {
        String path = this.buildDocumentPath(datasetId, documentId) + SEGMENTS_PATH;
        return this.executePost(path, request, SegmentListResponse.class);
    }

    @Override
    public SegmentListResponse getSegments(String datasetId, String documentId, String keyword, String status) throws IOException, DifyApiException {
        return this.getSegments(datasetId, documentId, keyword, status, null, null);
    }

    @Override
    public SegmentListResponse getSegments(String datasetId, String documentId, String keyword, String status, Integer page, Integer limit) throws IOException, DifyApiException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        this.addIfNotEmpty(queryParams, "keyword", keyword);
        this.addIfNotEmpty(queryParams, "status", status);
        this.addIfNotNull(queryParams, "page", page);
        this.addIfNotNull(queryParams, "limit", limit);
        String path = this.buildDocumentPath(datasetId, documentId) + SEGMENTS_PATH;
        String url = this.buildUrlWithParams(path, queryParams);
        return this.executeGet(url, SegmentListResponse.class);
    }

    @Override
    public SegmentResponse getSegment(String datasetId, String documentId, String segmentId) throws IOException, DifyApiException {
        String path = this.buildSegmentPath(datasetId, documentId, segmentId);
        return this.executeGet(path, SegmentResponse.class);
    }

    @Override
    public void deleteSegment(String datasetId, String documentId, String segmentId) throws IOException, DifyApiException {
        String path = this.buildSegmentPath(datasetId, documentId, segmentId);
        this.executeDelete(path, null, Object.class);
    }

    @Override
    public SegmentResponse updateSegment(String datasetId, String documentId, String segmentId, UpdateSegmentRequest request) throws IOException, DifyApiException {
        String path = this.buildSegmentPath(datasetId, documentId, segmentId);
        return this.executePost(path, request, SegmentResponse.class);
    }

    @Override
    public ChildChunkResponse createChildChunk(String datasetId, String documentId, String segmentId, SaveChildChunkRequest request) throws IOException, DifyApiException {
        String path = this.buildSegmentPath(datasetId, documentId, segmentId) + CHILD_CHUNKS_PATH;
        return this.executePost(path, request, ChildChunkResponse.class);
    }

    @Override
    public ChildChunkListResponse getChildChunks(String datasetId, String documentId, String segmentId, String keyword, Integer page, Integer limit) throws IOException, DifyApiException {
        String path = this.buildSegmentPath(datasetId, documentId, segmentId) + CHILD_CHUNKS_PATH;
        return this.executeGet(path, ChildChunkListResponse.class);
    }

    @Override
    public void deleteChildChunks(String datasetId, String documentId, String segmentId, String childChunkId) throws IOException, DifyApiException {
        String path = this.buildChildChunkPath(datasetId, documentId, segmentId, childChunkId);
        this.executeDelete(path, null, Object.class);
    }

    @Override
    public ChildChunkResponse updateChildChunk(String datasetId, String documentId, String segmentId, String childChunkId, SaveChildChunkRequest request) throws IOException, DifyApiException {
        String path = this.buildChildChunkPath(datasetId, documentId, segmentId, childChunkId);
        return this.executePatch(path, request, ChildChunkResponse.class);
    }

    @Override
    public UploadFileResponse getUploadFile(String datasetId, String documentId) throws IOException, DifyApiException {
        String path = this.buildDocumentPath(datasetId, documentId) + UPLOAD_FILE_PATH;
        return this.executeGet(path, UploadFileResponse.class);
    }

    @Override
    public RetrieveResponse retrieveDataset(String datasetId, RetrieveRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + RETRIEVE_PATH;
        return this.executePost(path, request, RetrieveResponse.class);
    }

    @Override
    public MetadataResponse createMetadata(String datasetId, CreateMetadataRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + METADATA_PATH;
        return this.executePost(path, request, MetadataResponse.class);
    }

    @Override
    public MetadataResponse updateMetadata(String datasetId, String metadataId, UpdateMetadataRequest request) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + METADATA_PATH + "/" + metadataId;
        return this.executePatch(path, request, MetadataResponse.class);
    }

    @Override
    public String deleteMetadata(String datasetId, String metadataId) throws IOException, DifyApiException {
        String path = "/datasets/" + datasetId + METADATA_PATH + "/" + metadataId;
        return this.executeDelete(path, null, String.class);
    }

    private <T> T executeMultipartRequest(String path, RequestBody requestBody, Class<T> responseClass) throws IOException, DifyApiException {
        Request httpRequest = new Request.Builder().url(this.baseUrl + path).post(requestBody).header("Authorization", "Bearer " + this.apiKey).build();
        try (Response response = this.httpClient.newCall(httpRequest).execute();){
            T t = this.handleResponse(response, responseClass);
            return t;
        }
    }

    private MultipartBody.Builder createMultipartBuilder(Object request, File file) {
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("data", JsonUtils.toJson(request)).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)OCTET_STREAM));
    }

    private String buildDocumentPath(String datasetId, String documentId) {
        return "/datasets/" + datasetId + DOCUMENTS_PATH + "/" + documentId;
    }

    private String buildSegmentPath(String datasetId, String documentId, String segmentId) {
        return this.buildDocumentPath(datasetId, documentId) + SEGMENTS_PATH + "/" + segmentId;
    }

    private String buildChildChunkPath(String datasetId, String documentId, String segmentId, String childChunkId) {
        return this.buildSegmentPath(datasetId, documentId, segmentId) + CHILD_CHUNKS_PATH + "/" + childChunkId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public String builtInMetadata(String datasetId, String action) throws IOException, DifyApiException {
        log.debug("\u542f\u7528/\u7981\u7528\u5185\u7f6e\u5143\u6570\u636e: datasetId={}, action={}", (Object)datasetId, (Object)action);
        String path = "/datasets/" + datasetId + METADATA_BUILT_IN_PATH + "/" + action;
        return this.executePost(path, null, String.class);
    }

    @Override
    public String updateDocumentMetadata(String datasetId, List<OperationData> operationDataList) throws IOException, DifyApiException {
        log.debug("\u66f4\u65b0\u6587\u6863\u5143\u6570\u636e: datasetId={}, operationDataList={}", (Object)datasetId, operationDataList);
        String path = "/datasets/" + datasetId + DOCUMENT_METADATA_PATH;
        HashMap<String, List<OperationData>> body = new HashMap<String, List<OperationData>>(1);
        body.put("operation_data", operationDataList);
        return this.executePost(path, body, String.class);
    }

    @Override
    public DocMetadataListResponse getDocMetadataList(String datasetId) throws IOException, DifyApiException {
        log.debug("\u67e5\u8be2\u77e5\u8bc6\u5e93\u5143\u6570\u636e\u5217\u8868: datasetId={}", (Object)datasetId);
        String path = "/datasets/" + datasetId + METADATA_PATH;
        Request request = this.createGetRequest(path);
        return this.executeRequest(request, DocMetadataListResponse.class);
    }

    @Override
    public EmbeddingModelListResponse getEmbeddingModelList() throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u5d4c\u5165\u6a21\u578b\u5217\u8868");
        Request request = this.createGetRequest(EMBEDDING_MODEL_TYPES_PATH);
        return this.executeRequest(request, EmbeddingModelListResponse.class);
    }

    @Override
    public TagResponse createTag(CreateTagRequest request) throws IOException, DifyApiException {
        log.debug("\u65b0\u589e\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e: name={}", (Object)request.getName());
        String path = "/datasets/tags";
        return this.executePost(path, request, TagResponse.class);
    }

    @Override
    public List<TagResponse> getTags() throws IOException, DifyApiException {
        log.debug("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e\u5217\u8868");
        String path = "/datasets/tags";
        Request request = this.createGetRequest(path);
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new DifyApiException(response.code(), "HTTP_ERROR", response.message());
            }
            String responseBody = response.body().string();
            TypeReference<List<TagResponse>> typeRef = new TypeReference<List<TagResponse>>(){};
            List<TagResponse> list = JsonUtils.fromJson(responseBody, typeRef);
            return list;
        }
    }

    @Override
    public TagResponse updateTag(UpdateTagRequest request) throws IOException, DifyApiException {
        log.debug("\u4fee\u6539\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e\u540d\u79f0: tagId={}, name={}", (Object)request.getTagId(), (Object)request.getName());
        String path = "/datasets/tags";
        return this.executePatch(path, request, TagResponse.class);
    }

    @Override
    public SimpleResponse deleteTag(DeleteTagRequest request) throws IOException, DifyApiException {
        log.debug("\u5220\u9664\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e: tagId={}", (Object)request.getTagId());
        String path = "/datasets/tags";
        return this.executeDelete(path, request, SimpleResponse.class);
    }

    @Override
    public SimpleResponse bindTags(TagBindRequest request) throws IOException, DifyApiException {
        log.debug("\u7ed1\u5b9a\u77e5\u8bc6\u5e93\u5230\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e: targetId={}, tagIds={}", (Object)request.getTargetId(), request.getTagIds());
        String path = "/datasets/tags/binding";
        return this.executePost(path, request, SimpleResponse.class);
    }

    @Override
    public SimpleResponse unbindTag(TagUnbindRequest request) throws IOException, DifyApiException {
        log.debug("\u89e3\u7ed1\u77e5\u8bc6\u5e93\u548c\u77e5\u8bc6\u5e93\u7c7b\u578b\u6807\u7b7e: targetId={}, tagId={}", (Object)request.getTargetId(), (Object)request.getTagId());
        String path = "/datasets/tags/unbinding";
        return this.executePost(path, request, SimpleResponse.class);
    }

    @Override
    public TagListResponse getDatasetTags(String datasetId) throws IOException, DifyApiException {
        log.debug("\u67e5\u8be2\u77e5\u8bc6\u5e93\u5df2\u7ed1\u5b9a\u7684\u6807\u7b7e: datasetId={}", (Object)datasetId);
        String path = "/datasets/" + datasetId + TAGS_PATH;
        return this.executePost(path, null, TagListResponse.class);
    }
}

