/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public interface ListStyleType {
    public static final String SYMBOL_DISC = "\uf06c";
    public static final String SYMBOL_CIRCLE = "\uf0a1";
    public static final String SYMBOL_DISCLOSURE_CLOSED = "\uf075";
    public static final String SYMBOL_DISCLOSURE_OPEN = "\uf071";
    public static final String SYMBOL_SQUARE = "\uf06e";
    public static final String FONT_WINGDINGS = "Wingdings";
    public static final String FONT_WINGDINGS_3 = "Wingdings 3";

    public String getName();

    public STNumberFormat.Enum getFormat();

    public String getText();

    public String getFont();

    public static enum Ordered implements ListStyleType
    {
        DECIMAL("decimal", STNumberFormat.DECIMAL, "", null),
        DECIMAL_LEADING_ZERO("decimal-leading-zero", STNumberFormat.DECIMAL_ZERO, "", null),
        CJK_DECIMAL("cjk-decimal", STNumberFormat.TAIWANESE_DIGITAL, "", null),
        HEBREW("hebrew", STNumberFormat.HEBREW_1, "", null),
        LOWER_ROMAN("lower-roman", STNumberFormat.LOWER_ROMAN, "", null),
        UPPER_ROMAN("upper-roman", STNumberFormat.UPPER_ROMAN, "", null),
        THAI("thai", STNumberFormat.THAI_NUMBERS, "", null),
        LOWER_ALPHA("lower-alpha", STNumberFormat.LOWER_LETTER, "", null),
        LOWER_LATIN("lower-latin", STNumberFormat.LOWER_LETTER, "", null),
        UPPER_ALPHA("upper-alpha", STNumberFormat.UPPER_LETTER, "", null),
        UPPER_LATIN("upper-latin", STNumberFormat.UPPER_LETTER, "", null),
        KATAKANA("katakana", STNumberFormat.AIUEO_FULL_WIDTH, "", null),
        KATAKANA_IROHA("katakana-iroha", STNumberFormat.IROHA_FULL_WIDTH, "", null),
        DISC("disc", STNumberFormat.BULLET, "\uf06c", "Wingdings"),
        CIRCLE("circle", STNumberFormat.BULLET, "\uf0a1", "Wingdings"),
        DISCLOSURE_CLOSED("disclosure-closed", STNumberFormat.BULLET, "\uf075", "Wingdings 3"),
        DISCLOSURE_OPEN("disclosure-open", STNumberFormat.BULLET, "\uf071", "Wingdings 3"),
        SQUARE("square", STNumberFormat.BULLET, "\uf06e", "Wingdings"),
        JAPANESE_INFORMAL("japanese-informal", STNumberFormat.JAPANESE_COUNTING, "", null),
        JAPANESE_FORMAL("japanese-formal", STNumberFormat.JAPANESE_LEGAL, "", null),
        KOREAN_HANGUL_FORMAL("korean-hangul-formal", STNumberFormat.KOREAN_COUNTING, "", null),
        KOREAN_HANJA_INFORMAL("korean-hanja-informal", STNumberFormat.KOREAN_DIGITAL_2, "", null),
        KOREAN_HANJA_FORMAL("korean-hanja-formal", STNumberFormat.CHINESE_LEGAL_SIMPLIFIED, "", null),
        SIMP_CHINESE_INFORMAL("simp-chinese-informal", STNumberFormat.CHINESE_COUNTING, "", null),
        SIMP_CHINESE_FORMAL("simp-chinese-formal", STNumberFormat.CHINESE_LEGAL_SIMPLIFIED, "", null),
        TRAD_CHINESE_INFORMAL("trad-chinese-informal", STNumberFormat.TAIWANESE_COUNTING, "", null),
        TRAD_CHINESE_FORMAL("trad-chinese-formal", STNumberFormat.CHINESE_LEGAL_SIMPLIFIED, "", null),
        CJK_IDEOGRAPHIC("cjk-ideographic", STNumberFormat.CHINESE_LEGAL_SIMPLIFIED, "", null),
        ONE("1", STNumberFormat.DECIMAL, "", null),
        LOWER_A("a", STNumberFormat.LOWER_LETTER, "", null),
        UPPER_A("A", STNumberFormat.UPPER_LETTER, "", null),
        LOWER_I("i", STNumberFormat.LOWER_ROMAN, "", null),
        UPPER_I("I", STNumberFormat.UPPER_ROMAN, "", null),
        NONE("none", STNumberFormat.NONE, null, null);

        private static final Map<String, ListStyleType> TYPE_MAP;
        private final String name;
        private final STNumberFormat.Enum format;
        private final String text;
        private final String font;

        private Ordered(String name, STNumberFormat.Enum format, String text, String font) {
            this.name = name;
            this.format = format;
            this.text = text;
            this.font = font;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public STNumberFormat.Enum getFormat() {
            return this.format;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getFont() {
            return this.font;
        }

        public static ListStyleType of(String type) {
            return TYPE_MAP.getOrDefault(type, DECIMAL);
        }

        static {
            TYPE_MAP = Arrays.stream(Ordered.values()).collect(Collectors.toMap(Ordered::getName, Function.identity()));
        }
    }

    public static enum Unordered implements ListStyleType
    {
        DISC("disc", STNumberFormat.BULLET, "\uf06c", "Wingdings"),
        CIRCLE("circle", STNumberFormat.BULLET, "\uf0a1", "Wingdings"),
        DECIMAL("decimal", STNumberFormat.DECIMAL, "", null),
        DISCLOSURE_CLOSED("disclosure-closed", STNumberFormat.BULLET, "\uf075", "Wingdings 3"),
        DISCLOSURE_OPEN("disclosure-open", STNumberFormat.BULLET, "\uf071", "Wingdings 3"),
        SQUARE("square", STNumberFormat.BULLET, "\uf06e", "Wingdings"),
        NONE("none", STNumberFormat.NONE, null, null);

        private static final Map<String, ListStyleType> TYPE_MAP;
        private final String name;
        private final STNumberFormat.Enum format;
        private final String text;
        private final String font;

        private Unordered(String name, STNumberFormat.Enum format, String text, String font) {
            this.name = name;
            this.format = format;
            this.text = text;
            this.font = font;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public STNumberFormat.Enum getFormat() {
            return this.format;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getFont() {
            return this.font;
        }

        public static ListStyleType of(String type) {
            return TYPE_MAP.getOrDefault(type, DISC);
        }

        static {
            TYPE_MAP = Arrays.stream(Unordered.values()).collect(Collectors.toMap(Unordered::getName, Function.identity()));
        }
    }
}

