/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CSSLengthUnit {
    CM("cm", true, false, false, 360000, 1, 1),
    MM("mm", true, false, false, 360000, 10, -1),
    IN("in", true, false, false, 12700, 72, 1),
    PX("px", true, false, false, 9525, 1, 1),
    PT("pt", true, false, false, 12700, 1, 1),
    PC("pc", true, false, false, 12700, 12, 1),
    EMU("emu", false, false, false, 1, 1, 1),
    TWIP("twip", false, false, false, 12700, 20, -1),
    REM("rem", true, true, false, 1, 1, 1),
    EM("em", true, true, true, 1, 1, 1),
    VW("vw", true, true, false, 1, 100, -1),
    VH("vh", true, true, false, 1, 100, -1),
    VMIN("vmin", true, true, false, 1, 100, -1),
    VMAX("vmax", true, true, false, 1, 100, -1),
    PERCENT("%", true, true, true, 1, 100, -1);

    private static final Map<String, CSSLengthUnit> LITERAL_MAP;
    private final String literal;
    private final boolean system;
    private final boolean relative;
    private final boolean relativeToParent;
    private final int unit;
    private final int factor;
    private final int power;

    private CSSLengthUnit(String literal, boolean system, boolean relative, boolean relativeToParent, int unit, int factor, int power) {
        this.literal = literal;
        this.system = system;
        this.relative = relative;
        this.relativeToParent = relativeToParent;
        this.unit = unit;
        this.factor = factor;
        this.power = power;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isRelativeToParent() {
        return this.relativeToParent;
    }

    public String toString() {
        return this.literal;
    }

    public double absoluteFactor() {
        return (double)this.unit * Math.pow(this.factor, this.power);
    }

    public double to(CSSLengthUnit other) {
        Objects.requireNonNull(other, "Target CSS length unit must not be null");
        if (this.isRelative()) {
            throw new IllegalArgumentException("Can not convert from a relative unit");
        }
        if (other.isRelative()) {
            throw new IllegalArgumentException("Can not convert to a relative unit");
        }
        return this.absoluteFactor() / other.absoluteFactor();
    }

    public static CSSLengthUnit of(String literal) {
        return LITERAL_MAP.get(literal);
    }

    static {
        LITERAL_MAP = Arrays.stream(CSSLengthUnit.values()).filter(CSSLengthUnit::isSystem).collect(Collectors.toMap(CSSLengthUnit::getLiteral, Function.identity()));
    }
}

