/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.png;

import com.drew.imaging.FileType;
import com.drew.imaging.png.PngChunkType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.png.PngDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class PngMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Png;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.PNG;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof PngDirectory) || ((PngDirectory)directory).getPngChunkType() != PngChunkType.IHDR) continue;
            Integer width = directory.getInteger(1);
            Integer height = directory.getInteger(2);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

