/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.jpeg;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class JpegMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Jpeg;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.JPG;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof JpegDirectory)) continue;
            Integer width = directory.getInteger(3);
            Integer height = directory.getInteger(1);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

