/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler.reporting.json;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import fr.jcgay.maven.profiler.reporting.Files;
import fr.jcgay.maven.profiler.reporting.Format;
import fr.jcgay.maven.profiler.reporting.ReportDirectory;
import fr.jcgay.maven.profiler.reporting.ReportFormat;
import fr.jcgay.maven.profiler.reporting.Reporter;
import fr.jcgay.maven.profiler.reporting.template.Data;
import fr.jcgay.maven.profiler.reporting.template.EntryAndTime;
import fr.jcgay.maven.profiler.reporting.template.Project;
import java.io.File;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonReporter.class);

    @Override
    public void write(Data data, ReportDirectory directory) {
        String reportString = this.getJSONRepresentation(data);
        File file = directory.fileName(data.getDate(), ReportFormat.JSON);
        Files.write(file, reportString);
        LOGGER.info("JSON profiling report has been saved in: {}", (Object)file);
    }

    private String getJSONRepresentation(Data context) {
        JsonObject obj = new JsonObject();
        obj.add("name", context.getTopProjectName());
        obj.add("profile_name", context.getProfileName());
        obj.add("time", Format.ms(context.getBuildTime()));
        obj.add("goals", context.getGoals());
        obj.add("date", context.getFormattedDate());
        obj.add("parameters", context.getParameters().toString());
        JsonArray projectsArr = new JsonArray();
        for (Project project : context.getProjects()) {
            JsonObject projectObj = new JsonObject();
            projectObj.add("project", project.getName());
            projectObj.add("time", Format.ms(project.getTime()));
            JsonArray projectMojosArr = new JsonArray();
            for (EntryAndTime<MojoExecution> entry : project.getMojosWithTime()) {
                JsonObject projectMojoObj = new JsonObject();
                projectMojoObj.add("mojo", entry.getEntry().toString());
                projectMojoObj.add("time", Format.ms(entry.getTime()));
                projectMojosArr.add((JsonValue)projectMojoObj);
            }
            projectObj.add("mojos", (JsonValue)projectMojosArr);
            projectsArr.add((JsonValue)projectObj);
        }
        obj.add("projects", (JsonValue)projectsArr);
        if (context.isDownloadSectionDisplayed()) {
            JsonArray downloadsArr = new JsonArray();
            for (EntryAndTime<Artifact> download : context.getDownloads()) {
                JsonObject downloadObj = new JsonObject();
                downloadObj.add("download", download.getEntry().toString());
                downloadObj.add("time", Format.ms(download.getTime()));
                downloadsArr.add((JsonValue)downloadObj);
            }
            obj.add("downloads", (JsonValue)downloadsArr);
        }
        return obj.toString();
    }
}

