/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class CalendarTileSkin
extends TileSkin {
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("EEEE");
    private static final DateTimeFormatter MONTH_YEAR_FORMATTER = DateTimeFormatter.ofPattern("MMMM YYYY");
    private Border weekBorder;
    private Text titleText;
    private Text text;
    private double cellOffsetX;
    private double cellOffsetY;
    private double cellWidth;
    private double cellHeight;
    private List<Label> labels;
    private EventHandler<MouseEvent> clickHandler;

    public CalendarTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        ZonedDateTime TIME = this.tile.getTime();
        this.titleText = new Text(MONTH_YEAR_FORMATTER.format(TIME));
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.clickHandler = e -> this.checkClick((MouseEvent)e);
        this.labels = new ArrayList<Label>(56);
        for (int i = 0; i < 56; ++i) {
            Label label = new Label();
            label.setManaged(false);
            label.setVisible(false);
            label.setAlignment(Pos.CENTER);
            label.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
            this.labels.add(label);
        }
        this.weekBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Tile.GRAY, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.NONE, BorderStrokeStyle.SOLID, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, CornerRadii.EMPTY, BorderWidths.DEFAULT, Insets.EMPTY)});
        this.text = new Text(DAY_FORMATTER.format(TIME));
        this.text.setFill((Paint)this.tile.getTextColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text});
        this.getPane().getChildren().addAll(this.labels);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.titleText.getText().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        }
    }

    @Override
    public void dispose() {
        this.labels.forEach(label -> label.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler));
        super.dispose();
    }

    private void drawCells() {
        ObservableList<ChartData> dataList = this.tile.getChartData();
        ZonedDateTime time = this.tile.getTime();
        Locale locale = this.tile.getLocale();
        int day = time.getDayOfMonth();
        int startDay = time.withDayOfMonth(1).getDayOfWeek().getValue();
        long lastDay = time.range(ChronoField.DAY_OF_MONTH).getMaximum();
        Color textColor = this.tile.getTextColor();
        Color bkgColor = this.tile.getBackgroundColor();
        Font regFont = Fonts.latoRegular(this.size * 0.045);
        Font bldFont = Fonts.latoBold(this.size * 0.045);
        Background bkgToday = new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBarColor(), new CornerRadii(this.size * 0.0125), new Insets(2.0))});
        Border appmntBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getAlarmColor(), (Paint)this.tile.getAlarmColor(), (Paint)this.tile.getAlarmColor(), (Paint)this.tile.getAlarmColor(), BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, new CornerRadii(this.size * 0.0125), BorderWidths.DEFAULT, new Insets(1.0))});
        boolean counting = false;
        int dayCounter = 1;
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 8; ++x) {
                String text;
                int index = y * 8 + x;
                Label label = this.labels.get(index);
                if (x == 0 && y == 0) {
                    text = "";
                    label.setManaged(false);
                    label.setVisible(false);
                } else if (y == 0) {
                    text = DayOfWeek.of(x).getDisplayName(TextStyle.SHORT, locale);
                    label.setTextFill((Paint)textColor);
                    label.setFont(bldFont);
                } else if (x == 0) {
                    text = Integer.toString(time.withDayOfMonth(1).plusDays((y - 1) * 7).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR));
                    label.setTextFill((Paint)Tile.GRAY);
                    label.setFont(regFont);
                    label.setBorder(this.weekBorder);
                } else {
                    if (index - 7 > startDay) {
                        counting = true;
                        text = Integer.toString(dayCounter);
                        LocalDate currentDay = time.toLocalDate().plusDays(dayCounter - 1);
                        long appointments = dataList.stream().filter(data -> data.getTimestampAsLocalDate().isEqual(currentDay)).count();
                        if (x == 7) {
                            if (appointments > 0L) {
                                label.setBorder(appmntBorder);
                            } else {
                                label.setBorder(null);
                            }
                            label.setTextFill((Paint)Tile.RED);
                            label.setFont(regFont);
                        } else if (dayCounter == day) {
                            if (appointments > 0L) {
                                label.setBorder(appmntBorder);
                            } else {
                                label.setBorder(null);
                            }
                            label.setBackground(bkgToday);
                            label.setTextFill((Paint)bkgColor);
                            label.setFont(bldFont);
                        } else {
                            int currentDayCounter = dayCounter;
                            if (dataList.stream().filter(data -> data.getTimestampAsLocalDate().getDayOfMonth() == currentDayCounter).count() > 0L) {
                                label.setBorder(appmntBorder);
                            } else {
                                label.setBorder(null);
                            }
                            label.setTextFill((Paint)textColor);
                            label.setFont(regFont);
                        }
                    } else {
                        text = "";
                        label.setManaged(false);
                        label.setVisible(false);
                    }
                    if ((long)dayCounter > lastDay) {
                        text = "";
                        label.setManaged(false);
                        label.setVisible(false);
                    }
                    if (counting) {
                        ++dayCounter;
                    }
                }
                label.setText(text);
                label.setVisible(true);
                label.setManaged(true);
                label.setPrefSize(this.cellWidth, this.cellHeight);
                label.relocate((double)x * this.cellWidth + this.cellOffsetX, (double)y * this.cellHeight + this.cellOffsetY);
            }
        }
    }

    private void checkClick(MouseEvent EVENT) {
        Label selectedLabel = (Label)EVENT.getSource();
        String selectedText = selectedLabel.getText();
        if (null == selectedText || selectedText.isEmpty() || !Character.isDigit(selectedText.charAt(0))) {
            return;
        }
        if (selectedLabel.getBorder() != null && selectedLabel.getBorder().equals((Object)this.weekBorder)) {
            return;
        }
        int selectedNo = Integer.parseInt(selectedText);
        if (selectedNo > 31) {
            return;
        }
        ObservableList<ChartData> dataList = this.tile.getChartData();
        ZonedDateTime time = this.tile.getTime();
        LocalDate selectedDate = LocalDate.of(time.getYear(), time.getMonth(), selectedNo);
        Optional<ChartData> selectedChartData = dataList.stream().filter(data -> data.getTimestampAsLocalDate().isEqual(selectedDate)).findAny();
        if (selectedChartData.isPresent()) {
            this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, selectedChartData.get()));
        }
    }

    @Override
    protected void resizeDynamicText() {
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        double offsetTop = this.size * 0.15;
        double offsetBottom = this.height - this.size * 0.15;
        this.contentBounds.setX(this.inset);
        this.contentBounds.setY(offsetTop);
        this.contentBounds.setWidth(this.width - this.doubleInset);
        this.contentBounds.setHeight(offsetBottom - offsetTop);
        this.contentCenterX = this.contentBounds.getX() + this.contentBounds.getWidth() * 0.5;
        this.contentCenterY = this.contentBounds.getY() + this.contentBounds.getHeight() * 0.5;
        double cellAreaWidth = this.contentBounds.getWidth();
        double cellAreaHeight = this.contentBounds.getHeight();
        this.cellOffsetX = this.contentBounds.getX();
        this.cellOffsetY = (this.height - cellAreaHeight) * 0.5;
        this.cellWidth = cellAreaWidth / 8.0;
        this.cellHeight = cellAreaHeight / 7.0;
        this.drawCells();
        this.redraw();
    }

    @Override
    protected void redraw() {
        super.redraw();
        ZonedDateTime TIME = this.tile.getTime();
        this.titleText.setText(MONTH_YEAR_FORMATTER.format(TIME));
        this.text.setText(DAY_FORMATTER.format(TIME));
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

