// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 *
 **/
public abstract class _ApplicationObserverDisp extends Ice.ObjectImpl implements ApplicationObserver
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceGrid::ApplicationObserver"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[1];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String ice_staticId()
    {
        return __ids[1];
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     *
     * @param serial The new serial number of the registry database.
     *
     * @param desc The descriptor of the new application.
     *
     **/
    public final void applicationAdded(int serial, ApplicationInfo desc)
    {
        applicationAdded(serial, desc, null);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     *
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     *
     * @param applications The applications currently registered with
     * the registry.
     *
     **/
    public final void applicationInit(int serial, java.util.List<ApplicationInfo> applications)
    {
        applicationInit(serial, applications, null);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     *
     * @param serial The new serial number of the registry database.
     *
     * @param name The name of the application that was removed.
     *
     **/
    public final void applicationRemoved(int serial, String name)
    {
        applicationRemoved(serial, name, null);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     *
     * @param serial The new serial number of the registry database.
     *
     * @param desc The descriptor of the update.
     *
     **/
    public final void applicationUpdated(int serial, ApplicationUpdateInfo desc)
    {
        applicationUpdated(serial, desc, null);
    }

    public static Ice.DispatchStatus ___applicationInit(ApplicationObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        int serial;
        java.util.List<ApplicationInfo> applications;
        serial = __is.readInt();
        applications = ApplicationInfoSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.applicationInit(serial, applications, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___applicationAdded(ApplicationObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        int serial;
        ApplicationInfo desc = null;
        serial = __is.readInt();
        desc = ApplicationInfo.__read(__is, desc);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.applicationAdded(serial, desc, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___applicationRemoved(ApplicationObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        int serial;
        String name;
        serial = __is.readInt();
        name = __is.readString();
        __inS.endReadParams();
        __obj.applicationRemoved(serial, name, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___applicationUpdated(ApplicationObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        int serial;
        ApplicationUpdateInfo desc = null;
        serial = __is.readInt();
        desc = ApplicationUpdateInfo.__read(__is, desc);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.applicationUpdated(serial, desc, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "applicationAdded",
        "applicationInit",
        "applicationRemoved",
        "applicationUpdated",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___applicationAdded(this, in, __current);
            }
            case 1:
            {
                return ___applicationInit(this, in, __current);
            }
            case 2:
            {
                return ___applicationRemoved(this, in, __current);
            }
            case 3:
            {
                return ___applicationUpdated(this, in, __current);
            }
            case 4:
            {
                return ___ice_id(this, in, __current);
            }
            case 5:
            {
                return ___ice_ids(this, in, __current);
            }
            case 6:
            {
                return ___ice_isA(this, in, __current);
            }
            case 7:
            {
                return ___ice_ping(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
