// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid administrative interface. </p>
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 *
 **/
public abstract class _AdminDisp extends Ice.ObjectImpl implements Admin
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceGrid::Admin"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[1];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String ice_staticId()
    {
        return __ids[1];
    }

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     **/
    public final void addApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               DeploymentException
    {
        addApplication(descriptor, null);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     *
     **/
    public final void addObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectExistsException
    {
        addObject(obj, null);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     **/
    public final void addObjectWithType(Ice.ObjectPrx obj, String type)
        throws DeploymentException,
               ObjectExistsException
    {
        addObjectWithType(obj, type, null);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final void enableServer(String id, boolean enabled)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        enableServer(id, enabled, null);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     *
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     *
     **/
    public final AdapterInfo[] getAdapterInfo(String id)
        throws AdapterNotExistException
    {
        return getAdapterInfo(id, null);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @return The adapter ids.
     *
     **/
    public final String[] getAllAdapterIds()
    {
        return getAllAdapterIds(null);
    }

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @return The application names.
     *
     **/
    public final String[] getAllApplicationNames()
    {
        return getAllApplicationNames(null);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @return The node names.
     *
     **/
    public final String[] getAllNodeNames()
    {
        return getAllNodeNames(null);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @return All the object infos with a stringified identity
     * matching the given expression.
     *
     **/
    public final ObjectInfo[] getAllObjectInfos(String expr)
    {
        return getAllObjectInfos(expr, null);
    }

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @return The registry names.
     *
     **/
    public final String[] getAllRegistryNames()
    {
        return getAllRegistryNames(null);
    }

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @return The server ids.
     *
     **/
    public final String[] getAllServerIds()
    {
        return getAllServerIds(null);
    }

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @return The application descriptor.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final ApplicationInfo getApplicationInfo(String name)
        throws ApplicationNotExistException
    {
        return getApplicationInfo(name, null);
    }

    /**
     * Get the default application descriptor.
     *
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     *
     **/
    public final ApplicationDescriptor getDefaultApplicationDescriptor()
        throws DeploymentException
    {
        return getDefaultApplicationDescriptor(null);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @return A proxy to the IceGrid node's admin object
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final Ice.ObjectPrx getNodeAdmin(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeAdmin(name, null);
    }

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @return The node hostname.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final String getNodeHostname(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeHostname(name, null);
    }

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @return The node information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final NodeInfo getNodeInfo(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeInfo(name, null);
    }

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @return The node load information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final LoadInfo getNodeLoad(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeLoad(name, null);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final int getNodeProcessorSocketCount(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeProcessorSocketCount(name, null);
    }

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @return The object info.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     **/
    public final ObjectInfo getObjectInfo(Ice.Identity id)
        throws ObjectNotRegisteredException
    {
        return getObjectInfo(id, null);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @return The object infos.
     *
     **/
    public final ObjectInfo[] getObjectInfosByType(String type)
    {
        return getObjectInfosByType(type, null);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @return A proxy to the IceGrid registry's admin object
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public final Ice.ObjectPrx getRegistryAdmin(String name)
        throws RegistryNotExistException
    {
        return getRegistryAdmin(name, null);
    }

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @return The registry information.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public final RegistryInfo getRegistryInfo(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        return getRegistryInfo(name, null);
    }

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @return A proxy to the server's admin object
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final Ice.ObjectPrx getServerAdmin(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerAdmin(id, null);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @return The category for server admin objects.
     *
     **/
    public final String getServerAdminCategory()
    {
        return getServerAdminCategory(null);
    }

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @return The server information.
     *
     **/
    public final ServerInfo getServerInfo(String id)
        throws ServerNotExistException
    {
        return getServerInfo(id, null);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @return The server's process id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final int getServerPid(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerPid(id, null);
    }

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @return The server state.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final ServerState getServerState(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerState(id, null);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public final java.util.Map<java.lang.String, java.lang.String> getSliceChecksums()
    {
        return getSliceChecksums(null);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if server instantiation
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void instantiateServer(String application, String node, ServerInstanceDescriptor desc)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        instantiateServer(application, node, desc, null);
    }

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final boolean isServerEnabled(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return isServerEnabled(id, null);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     **/
    public final void patchApplication_async(AMD_Admin_patchApplication __cb, String name, boolean shutdown)
        throws ApplicationNotExistException,
               PatchException
    {
        patchApplication_async(__cb, name, shutdown, null);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     **/
    public final void patchServer_async(AMD_Admin_patchServer __cb, String id, boolean shutdown)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        patchServer_async(__cb, id, shutdown, null);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @return true if the node ping succeeded, false otherwise.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     **/
    public final boolean pingNode(String name)
        throws NodeNotExistException
    {
        return pingNode(name, null);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @return true if the registry ping succeeded, false otherwise.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public final boolean pingRegistry(String name)
        throws RegistryNotExistException
    {
        return pingRegistry(name, null);
    }

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     *
     **/
    public final void removeAdapter(String id)
        throws AdapterNotExistException,
               DeploymentException
    {
        removeAdapter(id, null);
    }

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void removeApplication(String name)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        removeApplication(name, null);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public final void removeObject(Ice.Identity id)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        removeObject(id, null);
    }

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     *
     **/
    public final void sendSignal(String id, String signal)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        sendSignal(id, signal, null);
    }

    /**
     * Shut down the IceGrid registry.
     *
     **/
    public final void shutdown()
    {
        shutdown(null);
    }

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public final void shutdownNode(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        shutdownNode(name, null);
    }

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public final void shutdownRegistry(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        shutdownRegistry(name, null);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public final void startServer_async(AMD_Admin_startServer __cb, String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        startServer_async(__cb, id, null);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public final void stopServer_async(AMD_Admin_stopServer __cb, String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        stopServer_async(__cb, id, null);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void syncApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplication(descriptor, null);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void syncApplicationWithoutRestart(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplicationWithoutRestart(descriptor, null);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void updateApplication(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplication(descriptor, null);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public final void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplicationWithoutRestart(descriptor, null);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public final void updateObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        updateObject(obj, null);
    }

    public static Ice.DispatchStatus ___addApplication(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        ApplicationDescriptor descriptor = null;
        descriptor = ApplicationDescriptor.__read(__is, descriptor);
        __is.readPendingObjects();
        __inS.endReadParams();
        try
        {
            __obj.addApplication(descriptor, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___syncApplication(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        ApplicationDescriptor descriptor = null;
        descriptor = ApplicationDescriptor.__read(__is, descriptor);
        __is.readPendingObjects();
        __inS.endReadParams();
        try
        {
            __obj.syncApplication(descriptor, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___updateApplication(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        ApplicationUpdateDescriptor descriptor = null;
        descriptor = ApplicationUpdateDescriptor.__read(__is, descriptor);
        __is.readPendingObjects();
        __inS.endReadParams();
        try
        {
            __obj.updateApplication(descriptor, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___syncApplicationWithoutRestart(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        ApplicationDescriptor descriptor = null;
        descriptor = ApplicationDescriptor.__read(__is, descriptor);
        __is.readPendingObjects();
        __inS.endReadParams();
        try
        {
            __obj.syncApplicationWithoutRestart(descriptor, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___updateApplicationWithoutRestart(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        ApplicationUpdateDescriptor descriptor = null;
        descriptor = ApplicationUpdateDescriptor.__read(__is, descriptor);
        __is.readPendingObjects();
        __inS.endReadParams();
        try
        {
            __obj.updateApplicationWithoutRestart(descriptor, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___removeApplication(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.removeApplication(name, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___instantiateServer(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String application;
        String node;
        ServerInstanceDescriptor desc = null;
        application = __is.readString();
        node = __is.readString();
        desc = ServerInstanceDescriptor.__read(__is, desc);
        __inS.endReadParams();
        try
        {
            __obj.instantiateServer(application, node, desc, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___patchApplication(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        boolean shutdown;
        name = __is.readString();
        shutdown = __is.readBool();
        __inS.endReadParams();
        _AMD_Admin_patchApplication __cb = new _AMD_Admin_patchApplication(__inS);
        try
        {
            __obj.patchApplication_async(__cb, name, shutdown, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        catch(java.lang.Error ex)
        {
            __cb.__error(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___getApplicationInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            ApplicationInfo __ret = __obj.getApplicationInfo(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            ApplicationInfo.__write(__os, __ret);
            __os.writePendingObjects();
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(ApplicationNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getDefaultApplicationDescriptor(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        try
        {
            ApplicationDescriptor __ret = __obj.getDefaultApplicationDescriptor(__current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            ApplicationDescriptor.__write(__os, __ret);
            __os.writePendingObjects();
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getAllApplicationNames(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String[] __ret = __obj.getAllApplicationNames(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getServerInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            ServerInfo __ret = __obj.getServerInfo(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            ServerInfo.__write(__os, __ret);
            __os.writePendingObjects();
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getServerState(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            ServerState __ret = __obj.getServerState(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            ServerState.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getServerPid(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            int __ret = __obj.getServerPid(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeInt(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getServerAdminCategory(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String __ret = __obj.getServerAdminCategory(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        __os.writeString(__ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getServerAdmin(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            Ice.ObjectPrx __ret = __obj.getServerAdmin(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeProxy(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___enableServer(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        boolean enabled;
        id = __is.readString();
        enabled = __is.readBool();
        __inS.endReadParams();
        try
        {
            __obj.enableServer(id, enabled, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___isServerEnabled(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            boolean __ret = __obj.isServerEnabled(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeBool(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___startServer(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        _AMD_Admin_startServer __cb = new _AMD_Admin_startServer(__inS);
        try
        {
            __obj.startServer_async(__cb, id, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        catch(java.lang.Error ex)
        {
            __cb.__error(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___stopServer(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        _AMD_Admin_stopServer __cb = new _AMD_Admin_stopServer(__inS);
        try
        {
            __obj.stopServer_async(__cb, id, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        catch(java.lang.Error ex)
        {
            __cb.__error(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___patchServer(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        boolean shutdown;
        id = __is.readString();
        shutdown = __is.readBool();
        __inS.endReadParams();
        _AMD_Admin_patchServer __cb = new _AMD_Admin_patchServer(__inS);
        try
        {
            __obj.patchServer_async(__cb, id, shutdown, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        catch(java.lang.Error ex)
        {
            __cb.__error(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___sendSignal(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        String signal;
        id = __is.readString();
        signal = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.sendSignal(id, signal, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(BadSignalException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getAllServerIds(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String[] __ret = __obj.getAllServerIds(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getAdapterInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            AdapterInfo[] __ret = __obj.getAdapterInfo(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            AdapterInfoSeqHelper.write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AdapterNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___removeAdapter(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.removeAdapter(id, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AdapterNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getAllAdapterIds(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String[] __ret = __obj.getAllAdapterIds(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___addObject(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.ObjectPrx obj;
        obj = __is.readProxy();
        __inS.endReadParams();
        try
        {
            __obj.addObject(obj, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ObjectExistsException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___updateObject(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.ObjectPrx obj;
        obj = __is.readProxy();
        __inS.endReadParams();
        try
        {
            __obj.updateObject(obj, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ObjectNotRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___addObjectWithType(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.ObjectPrx obj;
        String type;
        obj = __is.readProxy();
        type = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.addObjectWithType(obj, type, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ObjectExistsException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___removeObject(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.Identity id = null;
        id = Ice.Identity.__read(__is, id);
        __inS.endReadParams();
        try
        {
            __obj.removeObject(id, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ObjectNotRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getObjectInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.Identity id = null;
        id = Ice.Identity.__read(__is, id);
        __inS.endReadParams();
        try
        {
            ObjectInfo __ret = __obj.getObjectInfo(id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            ObjectInfo.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(ObjectNotRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getObjectInfosByType(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String type;
        type = __is.readString();
        __inS.endReadParams();
        ObjectInfo[] __ret = __obj.getObjectInfosByType(type, __current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        ObjectInfoSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getAllObjectInfos(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String expr;
        expr = __is.readString();
        __inS.endReadParams();
        ObjectInfo[] __ret = __obj.getAllObjectInfos(expr, __current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        ObjectInfoSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___pingNode(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            boolean __ret = __obj.pingNode(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeBool(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getNodeLoad(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            LoadInfo __ret = __obj.getNodeLoad(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            LoadInfo.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getNodeInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            NodeInfo __ret = __obj.getNodeInfo(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            NodeInfo.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getNodeAdmin(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            Ice.ObjectPrx __ret = __obj.getNodeAdmin(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeProxy(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getNodeProcessorSocketCount(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            int __ret = __obj.getNodeProcessorSocketCount(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeInt(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___shutdownNode(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.shutdownNode(name, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getNodeHostname(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            String __ret = __obj.getNodeHostname(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeString(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getAllNodeNames(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String[] __ret = __obj.getAllNodeNames(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___pingRegistry(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            boolean __ret = __obj.pingRegistry(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeBool(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getRegistryInfo(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            RegistryInfo __ret = __obj.getRegistryInfo(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            RegistryInfo.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getRegistryAdmin(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            Ice.ObjectPrx __ret = __obj.getRegistryAdmin(name, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeProxy(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___shutdownRegistry(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.shutdownRegistry(name, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getAllRegistryNames(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String[] __ret = __obj.getAllRegistryNames(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___shutdown(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.shutdown(__current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getSliceChecksums(Admin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        java.util.Map<java.lang.String, java.lang.String> __ret = __obj.getSliceChecksums(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        Ice.SliceChecksumDictHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "addApplication",
        "addObject",
        "addObjectWithType",
        "enableServer",
        "getAdapterInfo",
        "getAllAdapterIds",
        "getAllApplicationNames",
        "getAllNodeNames",
        "getAllObjectInfos",
        "getAllRegistryNames",
        "getAllServerIds",
        "getApplicationInfo",
        "getDefaultApplicationDescriptor",
        "getNodeAdmin",
        "getNodeHostname",
        "getNodeInfo",
        "getNodeLoad",
        "getNodeProcessorSocketCount",
        "getObjectInfo",
        "getObjectInfosByType",
        "getRegistryAdmin",
        "getRegistryInfo",
        "getServerAdmin",
        "getServerAdminCategory",
        "getServerInfo",
        "getServerPid",
        "getServerState",
        "getSliceChecksums",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "instantiateServer",
        "isServerEnabled",
        "patchApplication",
        "patchServer",
        "pingNode",
        "pingRegistry",
        "removeAdapter",
        "removeApplication",
        "removeObject",
        "sendSignal",
        "shutdown",
        "shutdownNode",
        "shutdownRegistry",
        "startServer",
        "stopServer",
        "syncApplication",
        "syncApplicationWithoutRestart",
        "updateApplication",
        "updateApplicationWithoutRestart",
        "updateObject"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___addApplication(this, in, __current);
            }
            case 1:
            {
                return ___addObject(this, in, __current);
            }
            case 2:
            {
                return ___addObjectWithType(this, in, __current);
            }
            case 3:
            {
                return ___enableServer(this, in, __current);
            }
            case 4:
            {
                return ___getAdapterInfo(this, in, __current);
            }
            case 5:
            {
                return ___getAllAdapterIds(this, in, __current);
            }
            case 6:
            {
                return ___getAllApplicationNames(this, in, __current);
            }
            case 7:
            {
                return ___getAllNodeNames(this, in, __current);
            }
            case 8:
            {
                return ___getAllObjectInfos(this, in, __current);
            }
            case 9:
            {
                return ___getAllRegistryNames(this, in, __current);
            }
            case 10:
            {
                return ___getAllServerIds(this, in, __current);
            }
            case 11:
            {
                return ___getApplicationInfo(this, in, __current);
            }
            case 12:
            {
                return ___getDefaultApplicationDescriptor(this, in, __current);
            }
            case 13:
            {
                return ___getNodeAdmin(this, in, __current);
            }
            case 14:
            {
                return ___getNodeHostname(this, in, __current);
            }
            case 15:
            {
                return ___getNodeInfo(this, in, __current);
            }
            case 16:
            {
                return ___getNodeLoad(this, in, __current);
            }
            case 17:
            {
                return ___getNodeProcessorSocketCount(this, in, __current);
            }
            case 18:
            {
                return ___getObjectInfo(this, in, __current);
            }
            case 19:
            {
                return ___getObjectInfosByType(this, in, __current);
            }
            case 20:
            {
                return ___getRegistryAdmin(this, in, __current);
            }
            case 21:
            {
                return ___getRegistryInfo(this, in, __current);
            }
            case 22:
            {
                return ___getServerAdmin(this, in, __current);
            }
            case 23:
            {
                return ___getServerAdminCategory(this, in, __current);
            }
            case 24:
            {
                return ___getServerInfo(this, in, __current);
            }
            case 25:
            {
                return ___getServerPid(this, in, __current);
            }
            case 26:
            {
                return ___getServerState(this, in, __current);
            }
            case 27:
            {
                return ___getSliceChecksums(this, in, __current);
            }
            case 28:
            {
                return ___ice_id(this, in, __current);
            }
            case 29:
            {
                return ___ice_ids(this, in, __current);
            }
            case 30:
            {
                return ___ice_isA(this, in, __current);
            }
            case 31:
            {
                return ___ice_ping(this, in, __current);
            }
            case 32:
            {
                return ___instantiateServer(this, in, __current);
            }
            case 33:
            {
                return ___isServerEnabled(this, in, __current);
            }
            case 34:
            {
                return ___patchApplication(this, in, __current);
            }
            case 35:
            {
                return ___patchServer(this, in, __current);
            }
            case 36:
            {
                return ___pingNode(this, in, __current);
            }
            case 37:
            {
                return ___pingRegistry(this, in, __current);
            }
            case 38:
            {
                return ___removeAdapter(this, in, __current);
            }
            case 39:
            {
                return ___removeApplication(this, in, __current);
            }
            case 40:
            {
                return ___removeObject(this, in, __current);
            }
            case 41:
            {
                return ___sendSignal(this, in, __current);
            }
            case 42:
            {
                return ___shutdown(this, in, __current);
            }
            case 43:
            {
                return ___shutdownNode(this, in, __current);
            }
            case 44:
            {
                return ___shutdownRegistry(this, in, __current);
            }
            case 45:
            {
                return ___startServer(this, in, __current);
            }
            case 46:
            {
                return ___stopServer(this, in, __current);
            }
            case 47:
            {
                return ___syncApplication(this, in, __current);
            }
            case 48:
            {
                return ___syncApplicationWithoutRestart(this, in, __current);
            }
            case 49:
            {
                return ___updateApplication(this, in, __current);
            }
            case 50:
            {
                return ___updateApplicationWithoutRestart(this, in, __current);
            }
            case 51:
            {
                return ___updateObject(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
