// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 *
 **/
public interface _AdapterObserverOperations
{
    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     *
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     *
     * @param __current The Current object for the invocation.
     **/
    void adapterInit(AdapterInfo[] adpts, Ice.Current __current);

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     *
     * @param info The details of the new adapter.
     * @param __current The Current object for the invocation.
     **/
    void adapterAdded(AdapterInfo info, Ice.Current __current);

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     *
     * @param info The details of the updated adapter.
     *
     * @param __current The Current object for the invocation.
     **/
    void adapterUpdated(AdapterInfo info, Ice.Current __current);

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     *
     * @param id The ID of the removed adapter.
     *
     * @param __current The Current object for the invocation.
     **/
    void adapterRemoved(String id, Ice.Current __current);
}
