/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.spring;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.stream.StreamUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.spi.PathContentParser;
import com.yomahub.liteflow.util.PathMatchUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SpringPathContentParser
implements PathContentParser {
    public List<String> parseContent(List<String> pathList) throws Exception {
        List absolutePathList = PathMatchUtil.searchAbsolutePath(pathList);
        List<Resource> allResource = this.getResources(absolutePathList);
        ArrayList<String> contentList = new ArrayList<String>();
        for (Resource resource : allResource) {
            String content = IoUtil.read((InputStream)resource.getInputStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
            if (!StrUtil.isNotBlank((CharSequence)content)) continue;
            contentList.add(content);
        }
        return contentList;
    }

    public List<String> getFileAbsolutePath(List<String> pathList) throws Exception {
        List absolutePathList = PathMatchUtil.searchAbsolutePath(pathList);
        List<Resource> allResource = this.getResources(absolutePathList);
        return StreamUtil.of(allResource).filter(Resource::isFile).map(r -> {
            try {
                return r.getFile().getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private List<Resource> getResources(List<String> pathList) throws IOException {
        if (CollectionUtil.isEmpty(pathList)) {
            throw new ConfigErrorException("rule source must not be null");
        }
        ArrayList<Resource> allResource = new ArrayList<Resource>();
        Iterator<String> iterator = pathList.iterator();
        while (iterator.hasNext()) {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String path = iterator.next();
            String locationPattern = FileUtil.isAbsolutePath((String)path) && FileUtil.isFile((String)path) ? "file:" + path : (!path.startsWith("classpath:") && !path.startsWith("classpath*:") ? "classpath:" + path : path);
            Object[] resources = resolver.getResources(locationPattern);
            if (!ArrayUtil.isNotEmpty((Object[])resources)) continue;
            allResource.addAll(ListUtil.toList((Object[])resources));
        }
        HashSet fileTypeSet = new HashSet();
        allResource.forEach(resource -> fileTypeSet.add(FileUtil.extName((String)resource.getFilename())));
        if (fileTypeSet.size() > 1) {
            throw new ConfigErrorException("config error,please use the same type of configuration");
        }
        return allResource;
    }

    public int priority() {
        return 1;
    }
}

