/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.factory;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.exception.ErrorSupportPathException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.el.ClassJsonFlowELParser;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.el.ClassYmlFlowELParser;
import com.yomahub.liteflow.parser.factory.ClassParserFactory;
import com.yomahub.liteflow.parser.factory.FlowParserFactory;
import com.yomahub.liteflow.parser.factory.LocalParserFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class FlowParserProvider {
    private static final LFLog LOG = LFLoggerManager.getLogger(FlowExecutor.class);
    private static final FlowParserFactory LOCAL_PARSER_FACTORY = new LocalParserFactory();
    private static final Map<Predicate<String>, Function<String, FlowParser>> LOCAL_PARSER_DICT = new HashMap<Predicate<String>, Function<String, FlowParser>>(){
        {
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.xml$", (CharSequence)path), LOCAL_PARSER_FACTORY::createXmlELParser);
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.json$", (CharSequence)path), LOCAL_PARSER_FACTORY::createJsonELParser);
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.yml$", (CharSequence)path), LOCAL_PARSER_FACTORY::createYmlELParser);
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.xml$", (CharSequence)path), LOCAL_PARSER_FACTORY::createXmlELParser);
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.json$", (CharSequence)path), LOCAL_PARSER_FACTORY::createJsonELParser);
            this.put(path -> ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.yml$", (CharSequence)path), LOCAL_PARSER_FACTORY::createYmlELParser);
        }
    };
    private static final FlowParserFactory CLASS_PARSER_FACTORY = new ClassParserFactory();
    private static final Map<Predicate<Class<?>>, Function<String, FlowParser>> CLASS_PARSER_DICT = new HashMap<Predicate<Class<?>>, Function<String, FlowParser>>(){
        {
            this.put(ClassXmlFlowELParser.class::isAssignableFrom, CLASS_PARSER_FACTORY::createXmlELParser);
            this.put(ClassJsonFlowELParser.class::isAssignableFrom, CLASS_PARSER_FACTORY::createJsonELParser);
            this.put(ClassYmlFlowELParser.class::isAssignableFrom, CLASS_PARSER_FACTORY::createYmlELParser);
        }
    };

    public static FlowParser lookup(String path) throws Exception {
        String errorMsg = StrUtil.format((CharSequence)"can't support the format {}", (Object[])new Object[]{path});
        if (FlowParserProvider.isLocalConfig(path)) {
            Predicate dictKey = LOCAL_PARSER_DICT.keySet().stream().filter(key -> key.test(path)).findFirst().orElseThrow(() -> new ErrorSupportPathException(errorMsg));
            LOG.info("flow info loaded from local file,path={}", (Object)path);
            return LOCAL_PARSER_DICT.get(dictKey).apply(path);
        }
        if (FlowParserProvider.isClassConfig(path)) {
            String className = ReUtil.replaceAll((CharSequence)path, (String)"xml:|json:|yml:|el_xml:|el_json:|el_yml:", (String)"");
            Class<?> clazz = Class.forName(className);
            Predicate dictKey = CLASS_PARSER_DICT.keySet().stream().filter(key -> key.test(clazz)).findFirst().orElseThrow(() -> new ErrorSupportPathException(errorMsg));
            LOG.info("flow info loaded from class config with el,class={}", (Object)className);
            return CLASS_PARSER_DICT.get(dictKey).apply(className);
        }
        throw new ErrorSupportPathException(errorMsg);
    }

    private static boolean isLocalConfig(String path) {
        return ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.xml$", (CharSequence)path) || ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.json$", (CharSequence)path) || ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.yml$", (CharSequence)path) || ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.xml$", (CharSequence)path) || ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.json$", (CharSequence)path) || ReUtil.isMatch((String)"^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.yml$", (CharSequence)path);
    }

    private static boolean isClassConfig(String path) {
        return ReUtil.isMatch((String)"^(xml:|json:|yml:|el_xml:|el_json:|el_yml:)?\\w+(\\.\\w+)*$", (CharSequence)path);
    }

    protected static class ConfigRegexConstant {
        public static final String LOCAL_XML_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.xml$";
        public static final String LOCAL_JSON_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.json$";
        public static final String LOCAL_YML_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.yml$";
        public static final String LOCAL_EL_XML_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.xml$";
        public static final String LOCAL_EL_JSON_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.json$";
        public static final String LOCAL_EL_YML_CONFIG_REGEX = "^[\\w\\:\\-\\.\\@\\/\\\\\\*]+\\.el\\.yml$";
        public static final String PREFIX_FORMAT_CONFIG_REGEX = "xml:|json:|yml:|el_xml:|el_json:|el_yml:";
        public static final String CLASS_CONFIG_REGEX = "^(xml:|json:|yml:|el_xml:|el_json:|el_yml:)?\\w+(\\.\\w+)*$";

        protected ConfigRegexConstant() {
        }
    }
}

