/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.watch;

import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.watch.WatchException;
import com.xiaoleilu.hutool.watch.Watcher;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class WatchMonitor
extends Thread
implements Closeable {
    private static final Log log = LogFactory.get();
    public static final WatchEvent.Kind<?>[] EVENTS_ALL = new WatchEvent.Kind[]{StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
    private Path path;
    private Path filePath;
    private WatchService watchService;
    private Watcher watcher;
    private WatchEvent.Kind<?>[] events;
    private boolean isClosed;

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(Paths.get(uri), events);
    }

    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        try {
            return WatchMonitor.create(Paths.get(url.toURI()), events);
        }
        catch (URISyntaxException e) {
            throw new WatchException(e);
        }
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(file, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, events);
    }

    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(file.toPath(), events);
    }

    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get(path, new String[0]), events);
    }

    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this.path = path;
        this.events = events;
        this.init();
    }

    public void init() {
        if (this.path.toFile().isFile()) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.path.register(this.watchService, ArrayUtil.isEmpty(this.events) ? EVENTS_ALL : this.events);
        }
        catch (Exception e) {
            throw new WatchException(e);
        }
        this.isClosed = false;
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) {
        if (this.isClosed) {
            throw new WatchException("Watch Monitor is closed !");
        }
        log.debug("Start watching path: [{}]", this.path);
        while (!this.isClosed) {
            WatchKey wk;
            try {
                wk = this.watchService.take();
            }
            catch (InterruptedException e) {
                log.warn(e);
                return;
            }
            for (WatchEvent<?> event : wk.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (null != this.filePath && !this.filePath.endsWith(event.context().toString())) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    watcher.onCreate(event);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    watcher.onModify(event);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    watcher.onDelete(event);
                    continue;
                }
                if (kind != StandardWatchEventKinds.OVERFLOW) continue;
                watcher.onOverflow(event);
            }
            wk.reset();
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.close(this.watchService);
    }
}

