/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpException;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import com.xiaoleilu.hutool.http.ssl.SSLSocketFactoryBuilder;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.json.JSON;
import com.xiaoleilu.hutool.lang.Base64;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final String BOUNDARY = "--------------------Hutool_" + SecureUtil.simpleUUID();
    private static final byte[] BOUNDARY_END = StrUtil.format("--{}--\r\n", BOUNDARY).getBytes();
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX = "application/x-www-form-urlencoded;charset=";
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = "multipart/form-data; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    private String url = "";
    private Method method = Method.GET;
    private int timeout = -1;
    protected Map<String, Object> form;
    protected Map<String, File> fileForm;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private Boolean isFollowRedirects;
    private int redirectCount;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public HttpRequest(String url) {
        this.url = url;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return !connection.equalsIgnoreCase("close");
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest form(String name, Object value) {
        if (StrUtil.isBlank(name) || ObjectUtil.isNull(value)) {
            return this;
        }
        this.body = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (this.form == null) {
            this.form = new HashMap<String, Object>();
        }
        String strValue = value instanceof List ? CollectionUtil.join((List)value, ",") : (ArrayUtil.isArray(value) ? ArrayUtil.join((Object[])value, ",") : Convert.toStr(value, null));
        this.form.put(name, strValue);
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpRequest form(String name, File file) {
        if (null == file) {
            return this;
        }
        if (!this.isKeepAlive()) {
            this.keepAlive(true);
        }
        if (this.fileForm == null) {
            this.fileForm = new HashMap<String, File>();
        }
        this.fileForm.put(name, file);
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public HttpRequest body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return this;
    }

    public HttpRequest body(String body, String contentType) {
        this.body(body);
        this.contentType(contentType);
        return this;
    }

    public HttpRequest body(JSON json) {
        this.body(json.toString());
        String contentTypeJson = "application/json";
        if (StrUtil.isNotBlank(this.charset)) {
            contentTypeJson = StrUtil.format("{};charset={}", contentTypeJson, this.charset);
        }
        this.contentType(contentTypeJson);
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        return this.body(StrUtil.str(bodyBytes, this.charset));
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    public HttpRequest setFollowRedirects(Boolean isFollowRedirects) {
        this.isFollowRedirects = isFollowRedirects;
        return this;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        if (null == this.ssf) {
            try {
                this.ssf = SSLSocketFactoryBuilder.create().setProtocol(protocol).build();
            }
            catch (Exception e) {
                throw new HttpException(e);
            }
        }
        return this;
    }

    public HttpResponse execute() {
        this.urlWithParamIfGet();
        this.initConnecton();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPosible();
        if (null == httpResponse) {
            httpResponse = HttpResponse.readResponse(this.httpConnection);
        }
        this.httpConnection.disconnect();
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = Base64.encode(data, this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void initConnecton() {
        this.httpConnection = HttpConnection.create(this.url, this.method, this.hostnameVerifier, this.ssf, this.timeout).header(this.headers, true);
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
        if (null != this.isFollowRedirects) {
            this.httpConnection.setInstanceFollowRedirects(this.isFollowRedirects);
        }
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method)) {
            this.url = StrUtil.isNotBlank(this.body) ? HttpUtil.urlWithForm(this.url, this.body) : HttpUtil.urlWithForm(this.url, this.form);
        }
    }

    private HttpResponse sendRedirectIfPosible() {
        if (this.httpConnection.getHttpURLConnection().getInstanceFollowRedirects()) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
            if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                this.url = this.httpConnection.header(Header.LOCATION);
                if (this.redirectCount < 2) {
                    ++this.redirectCount;
                    return this.execute();
                }
                StaticLog.warn("URL [{}] redirect count more than two !", this.url);
            }
        }
        return null;
    }

    private void send() throws HttpException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method)) {
                if (CollectionUtil.isEmpty(this.fileForm)) {
                    this.sendFormUrlEncoded();
                } else {
                    this.sendMltipart();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank(this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX + this.charset, true);
        }
        String content = StrUtil.isNotBlank(this.body) ? this.body : HttpUtil.toParams(this.form, this.charset);
        IoUtil.write(this.httpConnection.getOutputStream(), this.charset, true, content);
    }

    private void sendMltipart() throws IOException {
        this.setMultipart();
        OutputStream out = this.httpConnection.getOutputStream();
        try {
            this.writeFileForm(out);
            this.writeForm(out);
            this.formEnd(out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IoUtil.close(out);
        }
    }

    private void writeForm(OutputStream out) throws IOException {
        if (CollectionUtil.isNotEmpty(this.form)) {
            StringBuilder builder = StrUtil.builder();
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                builder.append("--").append(BOUNDARY).append("\r\n");
                builder.append(StrUtil.format(CONTENT_DISPOSITION_TEMPLATE, entry.getKey()));
                builder.append(entry.getValue()).append("\r\n");
            }
            IoUtil.write(out, this.charset, false, builder);
        }
    }

    private void writeFileForm(OutputStream out) throws IOException {
        for (Map.Entry<String, File> entry : this.fileForm.entrySet()) {
            File file = entry.getValue();
            StringBuilder builder = StrUtil.builder().append("--").append(BOUNDARY).append("\r\n");
            builder.append(StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, entry.getKey(), file.getName()));
            builder.append(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType(file.getName())));
            IoUtil.write(out, this.charset, false, builder);
            FileUtil.writeToStream(file, out);
            IoUtil.write(out, this.charset, false, "\r\n");
        }
    }

    private void formEnd(OutputStream out) throws IOException {
        out.write(BOUNDARY_END);
        out.flush();
    }

    private void setMultipart() {
        this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_MULTIPART_PREFIX + BOUNDARY, true);
    }
}

