/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.symmetric;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCriptor {
    private SecretKey secretKey;
    private Cipher clipher;
    private AlgorithmParameterSpec params;
    private Lock lock = new ReentrantLock();

    public SymmetricCriptor(SymmetricAlgorithm algorithm) {
        this(algorithm, null);
    }

    public SymmetricCriptor(String algorithm) {
        this(algorithm, null);
    }

    public SymmetricCriptor(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCriptor(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public SymmetricCriptor init(String algorithm, byte[] key) {
        this.secretKey = SecureUtil.generateKey(algorithm, key);
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomUtil.randomBytes(8), 100);
        }
        try {
            this.clipher = Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.clipher.init(1, this.secretKey);
            } else {
                this.clipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.clipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes(data, CharsetUtil.CHARSET_UTF_8));
    }

    public byte[] encrypt(InputStream data) {
        try {
            return this.encrypt(IoUtil.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] decrypt(byte[] bytes) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.clipher.init(2, this.secretKey);
            } else {
                this.clipher.init(2, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.clipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(InputStream data) {
        try {
            return this.decrypt(IoUtil.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getClipher() {
        return this.clipher;
    }
}

