/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.asymmetric;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.asymmetric.KeyType;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.lang.Base64;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;

public class AsymmetricCriptor {
    protected String algorithm;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected Cipher clipher;
    protected Signature signature;
    protected Lock lock = new ReentrantLock();

    public AsymmetricCriptor(AsymmetricAlgorithm algorithm) {
        this(algorithm, null, null);
    }

    public AsymmetricCriptor(String algorithm) {
        this(algorithm, null, null);
    }

    public AsymmetricCriptor(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCriptor(String algorithm, byte[] privateKey, byte[] publicKey) {
        this.init(algorithm, privateKey, publicKey);
    }

    public AsymmetricCriptor init(String algorithm, byte[] privateKey, byte[] publicKey) {
        this.algorithm = algorithm;
        try {
            this.clipher = Cipher.getInstance(algorithm);
            this.signature = Signature.getInstance("MD5with" + algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        if (null == privateKey && null == publicKey) {
            this.initKeys();
        } else {
            if (null != privateKey) {
                this.privateKey = SecureUtil.generatePrivateKey(algorithm, privateKey);
            }
            if (null != publicKey) {
                this.publicKey = SecureUtil.generatePublicKey(algorithm, publicKey);
            }
        }
        return this;
    }

    public AsymmetricCriptor initKeys() {
        KeyPair keyPair = SecureUtil.generateKeyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return this;
    }

    public byte[] sign(byte[] data) {
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            return this.signature.sign();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            return this.signature.verify(sign);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public byte[] encrypt(byte[] data, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(1, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes(data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.bytes(data, CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public byte[] encrypt(InputStream data, KeyType keyType) {
        try {
            return this.encrypt(IoUtil.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(2, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(InputStream data, KeyType keyType) {
        try {
            return this.decrypt(IoUtil.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyBase64() {
        return Base64.encode(this.getPublicKey().getEncoded());
    }

    public AsymmetricCriptor setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivateKeyBase64() {
        return Base64.encode(this.getPrivateKey().getEncoded());
    }

    public AsymmetricCriptor setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public AsymmetricCriptor setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Cipher getClipher() {
        return this.clipher;
    }

    protected Key getKeyByType(KeyType type) {
        switch (type) {
            case PrivateKey: {
                if (null == this.privateKey) {
                    throw new NullPointerException("Private key must not null when use it !");
                }
                return this.privateKey;
            }
            case PublicKey: {
                if (null == this.privateKey) {
                    throw new NullPointerException("Public key must not null when use it !");
                }
                return this.publicKey;
            }
        }
        throw new CryptoException("Uknown key type: " + (Object)((Object)type));
    }
}

