/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.poi.excel;

import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.poi.excel.CellEditor;
import com.xiaoleilu.hutool.poi.excel.editors.TrimEditor;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class InternalExcelUtil {
    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        return InternalExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        if (null == cell) {
            return null;
        }
        return InternalExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return InternalExcelUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = InternalExcelUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = InternalExcelUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle cellStyle) {
        if (value instanceof Date) {
            short format = cellStyle.getDataFormat();
            if (0 == format) {
                CellStyle styleForDate = InternalExcelUtil.cloneCellStyle(cell, cellStyle);
                styleForDate.setDataFormat((short)22);
                cell.setCellStyle(styleForDate);
            }
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            short format;
            if ((value instanceof Double || value instanceof Float) && 0 == (format = cellStyle.getDataFormat())) {
                CellStyle styleForDouble = InternalExcelUtil.cloneCellStyle(cell, cellStyle);
                styleForDouble.setDataFormat((short)2);
                cell.setCellStyle(styleForDouble);
            }
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static CellStyle cloneCellStyle(Cell cell, CellStyle cellStyle) {
        CellStyle newCellStyle = cell.getSheet().getWorkbook().createCellStyle();
        newCellStyle.cloneStyleFrom(cellStyle);
        return newCellStyle;
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        ArrayList<Object> cellValues = new ArrayList<Object>();
        short length = row.getLastCellNum();
        for (short i = 0; i < length; i = (short)(i + 1)) {
            cellValues.add(InternalExcelUtil.getCellValue(row.getCell((int)i), cellEditor));
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, CellStyle cellStyle) {
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            if (null != cellStyle) {
                cell.setCellStyle(cellStyle);
            }
            InternalExcelUtil.setCellValue(cell, value, cellStyle);
            ++i;
        }
    }

    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return InternalExcelUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return InternalExcelUtil.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Workbook type [{}] is not supported!", workbook.getClass()));
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (row < ca.getFirstRow() || row > ca.getLastRow() || column < ca.getFirstColumn() || column > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTopEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRightEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottomEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeftEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static CellStyle setAlign(CellStyle cellStyle, HorizontalAlignment halign, VerticalAlignment valign) {
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        return cellStyle;
    }

    public static CellStyle setBorder(CellStyle cellStyle, BorderStyle borderSize, IndexedColors colorIndex) {
        cellStyle.setBorderBottom(borderSize);
        cellStyle.setBottomBorderColor(colorIndex.index);
        cellStyle.setBorderLeft(borderSize);
        cellStyle.setLeftBorderColor(colorIndex.index);
        cellStyle.setBorderRight(borderSize);
        cellStyle.setRightBorderColor(colorIndex.index);
        cellStyle.setBorderTop(borderSize);
        cellStyle.setTopBorderColor(colorIndex.index);
        return cellStyle;
    }

    public static CellStyle setColor(CellStyle cellStyle, IndexedColors backgroundColor, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(backgroundColor.index);
        cellStyle.setFillPattern(fillPattern);
        return cellStyle;
    }

    public static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        InternalExcelUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        InternalExcelUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        return cellStyle;
    }

    public static CellStyle createHeadCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        InternalExcelUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        InternalExcelUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        InternalExcelUtil.setColor(cellStyle, IndexedColors.GREY_25_PERCENT, FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (CollectionUtil.isNotEmpty(pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StrUtil.format((CharSequence)"{}_{}", anchor.getRow1(), anchor.getCol1()), (PictureData)pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StrUtil.format((CharSequence)"{}_{}", ctMarker.getRow(), ctMarker.getCol()), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    private static Object getNumericValue(Cell cell) {
        long longPart;
        String format;
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null == style) {
            return value;
        }
        short formatIndex = style.getDataFormat();
        if (InternalExcelUtil.isDateType(formatIndex, format = style.getDataFormatString())) {
            return com.xiaoleilu.hutool.date.DateUtil.date(cell.getDateCellValue());
        }
        if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
            return longPart;
        }
        return value;
    }

    private static boolean isDateType(int formatIndex, String format) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)format);
    }
}

