/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.poi.excel;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.poi.excel.ExcelUtil;
import com.xiaoleilu.hutool.poi.excel.InternalExcelUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter
implements Closeable {
    private boolean isClosed;
    private Workbook workbook;
    private Sheet sheet;
    private File destFile;
    private CellStyle headCellStyle;
    private CellStyle cellStyle;
    private AtomicInteger currentRow = new AtomicInteger(0);

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file(destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(ExcelUtil.createBook(destFile), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this.workbook = workbook;
        this.sheet = workbook.createSheet(StrUtil.isBlank(sheetName) ? "sheet1" : sheetName);
        this.headCellStyle = InternalExcelUtil.createHeadCellStyle(workbook);
        this.cellStyle = InternalExcelUtil.createDefaultCellStyle(workbook);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int rowIndex = this.currentRow.get();
        Cell cell = this.sheet.createRow(rowIndex).createCell(0);
        if (null != this.headCellStyle) {
            cell.setCellStyle(this.headCellStyle);
            InternalExcelUtil.mergingCells(this.sheet, rowIndex, rowIndex, 0, lastColumn, this.headCellStyle);
        }
        if (null != content) {
            InternalExcelUtil.setCellValue(cell, content, this.headCellStyle);
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int index = 0;
        for (Object object : data) {
            if (object instanceof Iterable) {
                this.writeRow((Iterable)object);
            } else if (object instanceof Map) {
                this.writeRows((Map)object, 0 == index);
            } else {
                if (!BeanUtil.isBean(object.getClass())) break;
                this.writeRows(BeanUtil.beanToMap(object), 0 == index);
            }
            ++index;
        }
        if (0 == index) {
            this.writeRow(data);
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        InternalExcelUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.headCellStyle);
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        InternalExcelUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.cellStyle);
        return this;
    }

    public ExcelWriter writeRows(Map<?, ?> rowMap, boolean isWriteKeys) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (isWriteKeys) {
            this.writeHeadRow(rowMap.keySet());
            this.writeRow(rowMap.values());
        } else {
            this.writeRow(rowMap.values());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelWriter flush() throws IORuntimeException {
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream(this.destFile);
            this.flush(out);
        }
        finally {
            IoUtil.close(out);
        }
        return this;
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        IoUtil.close((Closeable)this.workbook);
        this.currentRow = null;
        this.headCellStyle = null;
        this.cellStyle = null;
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }
}

