/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.geo;

import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Serializable;

public class Location
implements Serializable {
    private static final long serialVersionUID = 7457963026513014856L;
    private final double latitude;
    private final double longitude;

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The supplied coordinates " + this + " are out of range.");
        }
    }

    public Location(Location other) {
        this(other.latitude, other.longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return StrUtil.format((CharSequence)"({}, {})", this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return Double.valueOf(this.latitude).equals(other.latitude) && Double.valueOf(this.longitude).equals(other.longitude);
        }
        return false;
    }

    public int hashCode() {
        int result = 42;
        long latBits = Double.doubleToLongBits(this.latitude);
        long lonBits = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(latBits ^ latBits >>> 32);
        result = 31 * result + (int)(lonBits ^ lonBits >>> 32);
        return result;
    }
}

