/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.core.extension;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.ActivationComparator;
import com.weibo.api.motan.core.extension.Scope;
import com.weibo.api.motan.core.extension.Spi;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class ExtensionLoader<T> {
    private static ConcurrentMap<Class<?>, ExtensionLoader<?>> extensionLoaders = new ConcurrentHashMap();
    private ConcurrentMap<String, T> singletonInstances = null;
    private ConcurrentMap<String, Class<T>> extensionClasses = null;
    private Class<T> type;
    private volatile boolean init = false;
    private static final String PREFIX = "META-INF/services/";
    private ClassLoader classLoader;

    private ExtensionLoader(Class<T> type) {
        this(type, Thread.currentThread().getContextClassLoader());
    }

    private ExtensionLoader(Class<T> type, ClassLoader classLoader) {
        this.type = type;
        this.classLoader = classLoader;
    }

    private void checkInit() {
        if (!this.init) {
            this.loadExtensionClasses();
        }
    }

    public Class<T> getExtensionClass(String name) {
        this.checkInit();
        return (Class)this.extensionClasses.get(name);
    }

    public T getExtension(String name) {
        this.checkInit();
        if (name == null) {
            return null;
        }
        try {
            Spi spi = this.type.getAnnotation(Spi.class);
            if (spi.scope() == Scope.SINGLETON) {
                return this.getSingletonInstance(name);
            }
            Class clz = (Class)this.extensionClasses.get(name);
            if (clz == null) {
                return null;
            }
            return clz.newInstance();
        }
        catch (Exception e) {
            ExtensionLoader.failThrows(this.type, "Error when getExtension " + name, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getSingletonInstance(String name) throws InstantiationException, IllegalAccessException {
        Object obj = this.singletonInstances.get(name);
        if (obj != null) {
            return (T)obj;
        }
        Class clz = (Class)this.extensionClasses.get(name);
        if (clz == null) {
            return null;
        }
        ConcurrentMap<String, T> concurrentMap = this.singletonInstances;
        synchronized (concurrentMap) {
            obj = this.singletonInstances.get(name);
            if (obj != null) {
                return (T)obj;
            }
            obj = clz.newInstance();
            this.singletonInstances.put(name, obj);
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionClass(Class<T> clz) {
        if (clz == null) {
            return;
        }
        this.checkInit();
        this.checkExtensionType(clz);
        String spiName = this.getSpiName(clz);
        ConcurrentMap<String, Class<T>> concurrentMap = this.extensionClasses;
        synchronized (concurrentMap) {
            if (this.extensionClasses.containsKey(spiName)) {
                ExtensionLoader.failThrows(clz, ":Error spiName already exist " + spiName);
            } else {
                this.extensionClasses.put(spiName, clz);
            }
        }
    }

    private synchronized void loadExtensionClasses() {
        if (this.init) {
            return;
        }
        this.extensionClasses = this.loadExtensionClasses(PREFIX);
        this.singletonInstances = new ConcurrentHashMap<String, T>();
        this.init = true;
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        ExtensionLoader.checkInterfaceType(type);
        ExtensionLoader<T> loader = (ExtensionLoader<T>)extensionLoaders.get(type);
        if (loader == null) {
            loader = ExtensionLoader.initExtensionLoader(type);
        }
        return loader;
    }

    public static synchronized <T> ExtensionLoader<T> initExtensionLoader(Class<T> type) {
        ExtensionLoader loader = (ExtensionLoader)extensionLoaders.get(type);
        if (loader == null) {
            loader = new ExtensionLoader(type);
            extensionLoaders.putIfAbsent(type, loader);
            loader = (ExtensionLoader)extensionLoaders.get(type);
        }
        return loader;
    }

    public List<T> getExtensions(String key) {
        this.checkInit();
        if (this.extensionClasses.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> exts = new ArrayList<T>(this.extensionClasses.size());
        block0: for (Map.Entry entry : this.extensionClasses.entrySet()) {
            Activation activation = ((Class)entry.getValue()).getAnnotation(Activation.class);
            if (StringUtils.isBlank((CharSequence)key)) {
                exts.add(this.getExtension((String)entry.getKey()));
                continue;
            }
            if (activation == null || activation.key() == null) continue;
            for (String k : activation.key()) {
                if (!key.equals(k)) continue;
                exts.add(this.getExtension((String)entry.getKey()));
                continue block0;
            }
        }
        Collections.sort(exts, new ActivationComparator());
        return exts;
    }

    private static <T> void checkInterfaceType(Class<T> clz) {
        if (clz == null) {
            ExtensionLoader.failThrows(clz, "Error extension type is null");
        }
        if (!clz.isInterface()) {
            ExtensionLoader.failThrows(clz, "Error extension type is not interface");
        }
        if (!ExtensionLoader.isSpiType(clz)) {
            ExtensionLoader.failThrows(clz, "Error extension type without @Spi annotation");
        }
    }

    private void checkExtensionType(Class<T> clz) {
        this.checkClassPublic(clz);
        this.checkConstructorPublic(clz);
        this.checkClassInherit(clz);
    }

    private void checkClassInherit(Class<T> clz) {
        if (!this.type.isAssignableFrom(clz)) {
            ExtensionLoader.failThrows(clz, "Error is not instanceof " + this.type.getName());
        }
    }

    private void checkClassPublic(Class<T> clz) {
        if (!Modifier.isPublic(clz.getModifiers())) {
            ExtensionLoader.failThrows(clz, "Error is not a public class");
        }
    }

    private void checkConstructorPublic(Class<T> clz) {
        Constructor<?>[] constructors = clz.getConstructors();
        if (constructors == null || constructors.length == 0) {
            ExtensionLoader.failThrows(clz, "Error has no public no-args constructor");
        }
        for (Constructor<?> constructor : constructors) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return;
        }
        ExtensionLoader.failThrows(clz, "Error has no public no-args constructor");
    }

    private static <T> boolean isSpiType(Class<T> clz) {
        return clz.isAnnotationPresent(Spi.class);
    }

    private ConcurrentMap<String, Class<T>> loadExtensionClasses(String prefix) {
        String fullName = prefix + this.type.getName();
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            Enumeration<URL> urls = this.classLoader == null ? ClassLoader.getSystemResources(fullName) : this.classLoader.getResources(fullName);
            if (urls == null || !urls.hasMoreElements()) {
                return new ConcurrentHashMap<String, Class<T>>();
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.parseUrl(this.type, url, classNames);
            }
        }
        catch (Exception e) {
            throw new MotanFrameworkException("ExtensionLoader loadExtensionClasses error, prefix: " + prefix + " type: " + this.type.getClass(), e);
        }
        return this.loadClass(classNames);
    }

    private ConcurrentMap<String, Class<T>> loadClass(List<String> classNames) {
        ConcurrentHashMap<String, Class<T>> map = new ConcurrentHashMap<String, Class<T>>();
        for (String className : classNames) {
            try {
                Class<?> clz = this.classLoader == null ? Class.forName(className) : Class.forName(className, true, this.classLoader);
                this.checkExtensionType(clz);
                String spiName = this.getSpiName(clz);
                if (map.containsKey(spiName)) {
                    ExtensionLoader.failThrows(clz, ":Error spiName already exist " + spiName);
                    continue;
                }
                map.put(spiName, clz);
            }
            catch (Exception e) {
                ExtensionLoader.failLog(this.type, "Error load spi class", e);
            }
        }
        return map;
    }

    public String getSpiName(Class<?> clz) {
        SpiMeta spiMeta = clz.getAnnotation(SpiMeta.class);
        String name = spiMeta != null && !"".equals(spiMeta.name()) ? spiMeta.name() : clz.getSimpleName();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUrl(Class<T> type, URL url, List<String> classNames) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String line = null;
            int indexNumber = 0;
            while ((line = reader.readLine()) != null) {
                this.parseLine(type, url, line, ++indexNumber, classNames);
            }
        }
        catch (Exception x) {
            ExtensionLoader.failLog(type, "Error reading spi configuration file", x);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException y) {
                ExtensionLoader.failLog(type, "Error closing spi configuration file", y);
            }
        }
    }

    private void parseLine(Class<T> type, URL url, String line, int lineNumber, List<String> names) throws IOException, ServiceConfigurationError {
        int cp;
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if ((line = line.trim()).length() <= 0) {
            return;
        }
        if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
            ExtensionLoader.failThrows(type, url, lineNumber, "Illegal spi configuration-file syntax");
        }
        if (!Character.isJavaIdentifierStart(cp = line.codePointAt(0))) {
            ExtensionLoader.failThrows(type, url, lineNumber, "Illegal spi provider-class name: " + line);
        }
        for (int i = Character.charCount(cp); i < line.length(); i += Character.charCount(cp)) {
            cp = line.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            ExtensionLoader.failThrows(type, url, lineNumber, "Illegal spi provider-class name: " + line);
        }
        if (!names.contains(line)) {
            names.add(line);
        }
    }

    private static <T> void failLog(Class<T> type, String msg, Throwable cause) {
        LoggerUtil.error(type.getName() + ": " + msg, cause);
    }

    private static <T> void failThrows(Class<T> type, String msg, Throwable cause) {
        throw new MotanFrameworkException(type.getName() + ": " + msg, cause);
    }

    private static <T> void failThrows(Class<T> type, String msg) {
        throw new MotanFrameworkException(type.getName() + ": " + msg);
    }

    private static <T> void failThrows(Class<T> type, URL url, int line, String msg) throws ServiceConfigurationError {
        ExtensionLoader.failThrows(type, url + ":" + line + ": " + msg);
    }
}

