/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractServiceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.ConfigUtil;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.config.handler.ConfigHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class ServiceConfig<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = -3342374271064293224L;
    private static ConcurrentHashSet<String> existingServices = new ConcurrentHashSet();
    protected List<MethodConfig> methods;
    private T ref;
    private List<Exporter<T>> exporters = new CopyOnWriteArrayList<Exporter<T>>();
    private Class<T> interfaceClass;
    private BasicServiceInterfaceConfig basicService;
    private AtomicBoolean exported = new AtomicBoolean(false);
    private ConcurrentHashSet<URL> registereUrls = new ConcurrentHashSet();

    public static ConcurrentHashSet<String> getExistingServices() {
        return existingServices;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public void setInterface(Class<T> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(MethodConfig methods) {
        this.methods = Collections.singletonList(methods);
    }

    public void setMethods(List<MethodConfig> methods) {
        this.methods = methods;
    }

    public boolean hasMethods() {
        return this.methods != null && this.methods.size() > 0;
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    public List<Exporter<T>> getExporters() {
        return Collections.unmodifiableList(this.exporters);
    }

    protected boolean serviceExists(URL url) {
        return existingServices.contains(url.getIdentity());
    }

    public synchronized void export() {
        if (this.exported.get()) {
            LoggerUtil.warn(String.format("%s has already been expoted, so ignore the export request!", this.interfaceClass.getName()));
            return;
        }
        this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        List<URL> registryUrls = this.loadRegistryUrls();
        if (registryUrls == null || registryUrls.size() == 0) {
            throw new IllegalStateException("Should set registry config for service:" + this.interfaceClass.getName());
        }
        Map<String, Integer> protocolPorts = this.getProtocolAndPort();
        for (ProtocolConfig protocolConfig : this.protocols) {
            Integer port = protocolPorts.get(protocolConfig.getId());
            if (port == null) {
                throw new MotanServiceException(String.format("Unknow port in service:%s, protocol:%s", this.interfaceClass.getName(), protocolConfig.getId()));
            }
            this.doExport(protocolConfig, port, registryUrls);
        }
        this.afterExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unexport() {
        if (!this.exported.get()) {
            return;
        }
        try {
            ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
            configHandler.unexport(this.exporters, this.registereUrls);
        }
        finally {
            this.afterUnexport();
        }
    }

    private void doExport(ProtocolConfig protocolConfig, int port, List<URL> registryURLs) {
        String hostAddress;
        String protocolName = protocolConfig.getName();
        if (protocolName == null || protocolName.length() == 0) {
            protocolName = URLParamType.protocol.getValue();
        }
        if (StringUtils.isBlank((CharSequence)(hostAddress = this.host)) && this.basicService != null) {
            hostAddress = this.basicService.getHost();
        }
        if (NetUtils.isInvalidLocalHost(hostAddress)) {
            hostAddress = this.getLocalHostAddress(registryURLs);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(URLParamType.nodeType.getName(), "service");
        map.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
        ServiceConfig.collectConfigParams(map, protocolConfig, this.basicService, this.extConfig, this);
        ServiceConfig.collectMethodConfigParams(map, this.getMethods());
        URL serviceUrl = new URL(protocolName, hostAddress, port, this.interfaceClass.getName(), map);
        if (this.serviceExists(serviceUrl)) {
            LoggerUtil.warn(String.format("%s configService is malformed, for same service (%s) already exists ", this.interfaceClass.getName(), serviceUrl.getIdentity()));
            throw new MotanFrameworkException(String.format("%s configService is malformed, for same service (%s) already exists ", this.interfaceClass.getName(), serviceUrl.getIdentity()), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if ("injvm".equals(protocolConfig.getId())) {
            URL localRegistryUrl = null;
            for (URL ru : registryURLs) {
                if (!"local".equals(ru.getProtocol())) continue;
                localRegistryUrl = ru.createCopy();
                break;
            }
            if (localRegistryUrl == null) {
                localRegistryUrl = new URL("local", hostAddress, 0, RegistryService.class.getName());
            }
            urls.add(localRegistryUrl);
        } else {
            for (URL ru : registryURLs) {
                urls.add(ru.createCopy());
            }
        }
        for (URL u : urls) {
            u.addParameter(URLParamType.embed.getName(), StringTools.urlEncode(serviceUrl.toFullStr()));
            this.registereUrls.add(u.createCopy());
        }
        ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
        this.exporters.add(configHandler.export(this.interfaceClass, this.ref, urls));
    }

    private void afterExport() {
        this.exported.set(true);
        for (Exporter<T> ep : this.exporters) {
            existingServices.add(ep.getProvider().getUrl().getIdentity());
        }
    }

    private void afterUnexport() {
        this.exported.set(false);
        for (Exporter<T> ep : this.exporters) {
            existingServices.remove(ep.getProvider().getUrl().getIdentity());
            this.exporters.remove(ep);
        }
        this.exporters.clear();
        this.registereUrls.clear();
    }

    @ConfigDesc(excluded=true)
    public BasicServiceInterfaceConfig getBasicService() {
        return this.basicService;
    }

    public void setBasicService(BasicServiceInterfaceConfig basicService) {
        this.basicService = basicService;
    }

    public Map<String, Integer> getProtocolAndPort() {
        if (StringUtils.isBlank((CharSequence)this.export)) {
            throw new MotanServiceException("export should not empty in service config:" + this.interfaceClass.getName());
        }
        return ConfigUtil.parseExport(this.export);
    }

    @Override
    @ConfigDesc(excluded=true)
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    public AtomicBoolean getExported() {
        return this.exported;
    }

    public ConcurrentHashSet<URL> getRegistereUrls() {
        return this.registereUrls;
    }
}

